package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.dto.OaBusinessDto;
import com.bcxin.oaflow.mapper.*;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.domain.attend.AttendReport;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendReportDto;
import com.bcxin.platform.dto.app.AppAttendSchedulClockDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendReportDto;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendLeaveMapper;
import com.bcxin.platform.mapper.attend.AttendMapper;
import com.bcxin.platform.mapper.attend.AttendReportMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.service.attend.AttendReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 考勤结果统计Service业务层处理
 * 
 * @author lin
 * @date 2021-08-30
 */
@Service
@Transactional("transactionManager")
public class AttendReportServiceImpl implements AttendReportService{

    @Autowired
    private AttendReportMapper attendReportMapper;

    @Autowired
    private AttendClockMapper attendClockMapper;

    @Autowired
    private AttendLeaveMapper attendLeaveMapper;

    @Autowired
    private AttendMapper attendMapper;

    @Autowired
    private BusinessTravelMapper businessTravelMapper;

    @Autowired
    private LeaveApplicationMapper leaveApplicationMapper;

    @Autowired
    private PublicReleaseMapper publicReleaseMapper;

    @Autowired
    private WorkOvertimeMapper workOvertimeMapper;

    @Autowired
    private MakeUpCardMapper makeUpCardMapper;

    @Autowired
    private PerBaseInfoMapper perBaseInfoMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤结果统计
     * 
     * @param id 考勤结果统计ID
     * @return 考勤结果统计
     */
    @Override
    public AttendReportDto findById(Long id){
        AttendReportDto reportDto = attendReportMapper.findDetail(id);
        AttendClockDto attendClock = new AttendClockDto();
        attendClock.setSchedulDate(reportDto.getReportDate());
        attendClock.setPerId(reportDto.getPerId());
        List<AttendClockDto> clockList = attendClockMapper.selectList(attendClock);
        reportDto.setClockList(clockList);
        return reportDto;
    }

    /**
     * 查询考勤结果统计列表
     * 
     * @param searchDto 考勤结果统计
     * @return 考勤结果统计
     */
    @Override
    public List<AttendReportDto> selectList(AttendReportDto searchDto){
        //加上数据权限
        if(!searchDto.isDomainAdmin() && (searchDto.getAdminDepartIds()== null || searchDto.getAdminDepartIds().size() == 0)){
            return new ArrayList<>();
        }
        return attendReportMapper.selectList(searchDto);
    }

    /**
     * 修改考勤结果统计
     * 
     * @param attendReport 考勤结果统计
     * @return 结果
     */
    @Override
    public int update(AttendReport attendReport){
        if(attendReport.getId() == null){
            attendReport.setCreateTime(DateUtils.getNowDate());
            attendReport.setId(idWorker.nextId());
        }else{
            AttendReport dbAttendReport = attendReportMapper.findById(attendReport.getId());
            BeanUtils.copyPropertiesIgnore(attendReport,dbAttendReport,true);
            BeanUtils.copyPropertiesIgnore(dbAttendReport,attendReport,false);
        }
        attendReport.setUpdateTime(DateUtils.getNowDate());
        return attendReportMapper.save(attendReport);
    }

    @Override
    public AttendReportDto findDetail(Long id) {
        AttendReportDto reportDto = attendReportMapper.findDetail(id);
        AttendClockDto attendClock = new AttendClockDto();
        attendClock.setSchedulDate(reportDto.getReportDate());
        attendClock.setPerId(reportDto.getPerId());
        attendClock.setDomainAdmin(true);
        List<AttendClockDto> clockList = attendClockMapper.selectList(attendClock);
        reportDto.setClockList(clockList);
        AttendLeave attendLeave = new AttendLeave();
        attendLeave.setPerId(reportDto.getPerId());
        attendLeave.setLeaveDate(reportDto.getReportDate());
        List<AttendLeave> leaveList = attendLeaveMapper.selectListGroupDate(attendLeave);
        reportDto.setLeaveList(leaveList);
        return reportDto;
    }

    @Override
    public AppAttendReportDto findMonthStatistics(AppAttendSearchDto searchDto) {
        Attend attend = attendMapper.findByPerId(searchDto.getPerId());
        if(attend == null){
            throw new BusinessException("无相关考勤套");
        }

        AppAttendReportDto reportDto = attendReportMapper.findMonthStatistics(searchDto);

        if(reportDto == null){
            //还未生成月统计的，根据日结果手动统计
            reportDto = attendReportMapper.findMonthReport(searchDto);
        }

        List<AppAttendReportDto> dayReportList = new ArrayList<>();
        Map<String, AppAttendReportDto> perMap = new HashMap<>();
        List<AppAttendSchedulClockDto> schedulClockList = attendClockMapper.selectListForApp(searchDto);

        if(reportDto == null){
            if(schedulClockList.size() == 0){
                throw new BusinessException("无相关统计信息");
            }else{
                //未生成日结果
                reportDto = new AppAttendReportDto();
                reportDto.setReportDate(DateUtils.dateTimeNow(DateUtils.YYYY_MM));

                PerBaseInfo perBaseInfo = perBaseInfoMapper.selectPerBaseInfoById(searchDto.getPerId());
                reportDto.setTlkPerId(perBaseInfo.getTlkPerId());
            }
        }

        List<MakeUpCard> cardList = makeUpCardMapper.selectList(Arrays.asList(reportDto.getTlkPerId().split(",")), reportDto.getReportDate());
        Map<Date,List<MakeUpCard>> cardsMap = cardList.stream().collect(Collectors.groupingBy(MakeUpCard::getStartTime));

        for (AppAttendSchedulClockDto schedulClockDto : schedulClockList) {
            if (StrUtil.isEmpty(schedulClockDto.getClockStart())
            || (schedulClockDto.getLateMin() != null && schedulClockDto.getLateMin() > 0)) {
                //已申请的补卡记录
                if(cardsMap.get(DateUtils.parseDate(schedulClockDto.getStartTime())) != null){
                    List<MakeUpCard> subCards = cardsMap.get(DateUtils.parseDate(schedulClockDto.getStartTime()));
                    for (MakeUpCard subCard : subCards) {
                        if(DictConst.CLOCKTYPE_SB.equals(subCard.getCardType())){
                            schedulClockDto.setStartStatus(DictConst.CARDAPPLYSTATUS_6);
                            if(DictConst.APPLYSTATUS_TG_CH.equals(subCard.getState())){
                                schedulClockDto.setStartStatus(DictConst.CARDAPPLYSTATUS_61);
                            }
                            break;
                        }
                    }
                }
            }

            if(DictConst.SHIFTTYPE_JCBC.equals(schedulClockDto.getShiftType())){
                continue;
            }

            if (StrUtil.isEmpty(schedulClockDto.getClockEnd())
            ||(schedulClockDto.getLeaveEarly() != null && schedulClockDto.getLeaveEarly() > 0)) {
                //已申请的补卡记录
                if(cardsMap.get(DateUtils.parseDate(schedulClockDto.getEndTime())) != null){
                    List<MakeUpCard> subCards = cardsMap.get(DateUtils.parseDate(schedulClockDto.getEndTime()));
                    for (MakeUpCard subCard : subCards) {
                        if(DictConst.CLOCKTYPE_XB.equals(subCard.getCardType())){
                            schedulClockDto.setEndStatus(DictConst.CARDAPPLYSTATUS_6);
                            if(DictConst.APPLYSTATUS_TG_CH.equals(subCard.getState())){
                                schedulClockDto.setEndStatus(DictConst.CARDAPPLYSTATUS_61);
                            }
                            break;
                        }
                    }
                }
            }
        }

        Map<String,List<AppAttendSchedulClockDto>> schedulClockMap = schedulClockList.stream().collect(Collectors.groupingBy(AppAttendSchedulClockDto::getSchedulDate));

        if(reportDto != null) {
            dayReportList = attendReportMapper.findDayStatistics(searchDto);
            perMap = dayReportList.stream().collect(Collectors.toMap(AppAttendReportDto::getReportDate, Function.identity()));
            for (AppAttendReportDto attendReportDto : dayReportList) {
                //每日排班打卡详情
                attendReportDto.setSchedulClockList(schedulClockMap.get(attendReportDto.getReportDate()));
            }
        }

        //需要再减去本月已补卡次数
        if(attend.getCountLimit() != null) {
            reportDto.setCountLimit(attend.getCountLimit() - cardList.size());
        }

        AppAttendReportDto attendReportDto = null;

        for (String key : schedulClockMap.keySet()) {
            if(perMap.get(key) == null){
                // 有排班还未开始的日期
                attendReportDto = new AppAttendReportDto();
                attendReportDto.setReportDate(key);
                attendReportDto.setAttendReportType(DictConst.ATTENDREPORTTYPE_DAY);

                List<AppAttendSchedulClockDto> dayClockList = schedulClockMap.get(key);

                for (AppAttendSchedulClockDto schedulClockDto : dayClockList) {

                    if(DictConst.SHIFTTYPE_JCBC.equals(schedulClockDto.getShiftType())){
                        continue;
                    }

                    if(DictConst.CLOCKSTATUS_3.equals(schedulClockDto.getClockStatus())){
                        if(StrUtil.isEmpty(schedulClockDto.getClockEnd())){
                            if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.addMinutes(DateUtils.getNowDate(),-30).getTime()){
                                //下班缺卡
                                schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_23);
                            }
                        }
                    }else if(StrUtil.isEmpty(schedulClockDto.getClockStatus())){
                        if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.getNowDate().getTime()){
                            //过了下班时间
                            if(StrUtil.isEmpty(schedulClockDto.getClockStart())){
                                //缺勤
                                if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.addMinutes(DateUtils.getNowDate(),-30).getTime()) {
                                    schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_5);
                                }else{
                                    schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_21);
                                }
                            }else{
                                //下班缺卡
                                if(DateUtils.parseDate(schedulClockDto.getEndTime()).getTime()<DateUtils.addMinutes(DateUtils.getNowDate(),-30).getTime()) {
                                    schedulClockDto.setClockStatus(DictConst.CLOCKSTATUS_22);
                                }
                            }
                        }
                    }
                }

                attendReportDto.setSchedulClockList(dayClockList);





                dayReportList.add(attendReportDto);
            }
        }

        List<OaBusinessDto>  oaList = new ArrayList<>();

        //TODO 加上请假、公出、出差记录
        oaList.addAll(leaveApplicationMapper.findByUserId(reportDto.getTlkPerId(),searchDto.getSchedulDate()));
        oaList.addAll(publicReleaseMapper.findByUserId(reportDto.getTlkPerId(),searchDto.getSchedulDate()));
        oaList.addAll(businessTravelMapper.findByUserId(reportDto.getTlkPerId(),searchDto.getSchedulDate()));

        //TODO 加上加班记录
        oaList.addAll(workOvertimeMapper.findByUserId(reportDto.getTlkPerId(),searchDto.getSchedulDate()));

        //排序
        dayReportList = dayReportList.stream().sorted(Comparator.comparing(AppAttendReportDto::getReportDate)).collect(Collectors.toList());

        if(oaList.size() > 0){
            Date startTime = oaList.stream().min((a,b)-> a.getStartTime().getTime()>b.getStartTime().getTime() ? 1:-1).get().getStartTime();
            Date endTime = oaList.stream().max((a,b)-> a.getStopTime().getTime()>b.getStopTime().getTime() ? 1:-1).get().getStopTime();

            for (OaBusinessDto oaBusinessDto : oaList) {
                for (AppAttendReportDto appAttendReportDto : dayReportList) {
                    List<OaBusinessDto> dayOaList = appAttendReportDto.getOaList();
                    if(dayOaList == null){
                        dayOaList = new ArrayList<>();
                    }
                    if(DictConst.OA_DICTTYPE_1.equals(oaBusinessDto.getDictType())){
                        if(DateUtils.formatDate(oaBusinessDto.getStartTime(),DateUtils.YYYY_MM_DD).equals(appAttendReportDto.getReportDate())){
                            dayOaList.add(oaBusinessDto);
                        }
                        continue;
                    }

                    if(appAttendReportDto.getSchedulClockList() == null || appAttendReportDto.getSchedulClockList().size()<1){
                        continue;
                    }

                    for (AppAttendSchedulClockDto appAttendSchedulClockDto : appAttendReportDto.getSchedulClockList()) {
                        if(DictConst.SHIFTTYPE_JCBC.equals(appAttendSchedulClockDto.getShiftType())){
                            continue;
                        }

                        if(DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()).getTime()>oaBusinessDto.getStartTime().getTime()
                                && DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()).getTime()<oaBusinessDto.getStopTime().getTime()){
                            //上班时间在请假、公出、出差时间范围内
                            OaBusinessDto newOaBusiness = new OaBusinessDto();
                            newOaBusiness.setStartTime(DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()));
                            newOaBusiness.setStopTime(DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()));
                            newOaBusiness.setDictType(oaBusinessDto.getDictType());

                            appAttendSchedulClockDto.setStartStatus(DictConst.CARDAPPLYSTATUS_11);
                            appAttendSchedulClockDto.setEndStatus(DictConst.CARDAPPLYSTATUS_11);
                            dayOaList.add(newOaBusiness);
                        }else if(DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()).getTime()<oaBusinessDto.getStartTime().getTime()
                                && DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()).getTime()>oaBusinessDto.getStopTime().getTime()){
                            //请假、公出、出差时间在上班时间范围内
                            dayOaList.add(oaBusinessDto);
                        }else if(DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()).getTime()<oaBusinessDto.getStartTime().getTime()
                                && DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()).getTime()>oaBusinessDto.getStartTime().getTime()
                                && DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()).getTime()<oaBusinessDto.getStopTime().getTime()){
                            //请假、公出、出差开始时间在上班时间内，结束时间晚于上班时间结束时间
                            OaBusinessDto newOaBusiness = new OaBusinessDto();
                            newOaBusiness.setStartTime(oaBusinessDto.getStartTime());
                            newOaBusiness.setStopTime(DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()));
                            newOaBusiness.setDictType(oaBusinessDto.getDictType());
                            appAttendSchedulClockDto.setEndStatus(DictConst.CARDAPPLYSTATUS_11);
                            dayOaList.add(newOaBusiness);
                        }else if(DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()).getTime()>oaBusinessDto.getStartTime().getTime()
                                && DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()).getTime()<oaBusinessDto.getStopTime().getTime()
                                && DateUtils.parseDate(appAttendSchedulClockDto.getEndTime()).getTime()>oaBusinessDto.getStopTime().getTime()){
                            //请假、公出、出差开始时间早于上班时间开始时间，结束时间在上班时间范围内
                            OaBusinessDto newOaBusiness = new OaBusinessDto();
                            newOaBusiness.setStartTime(DateUtils.parseDate(appAttendSchedulClockDto.getStartTime()));
                            newOaBusiness.setStopTime(oaBusinessDto.getStopTime());
                            newOaBusiness.setDictType(oaBusinessDto.getDictType());
                            appAttendSchedulClockDto.setStartStatus(DictConst.CARDAPPLYSTATUS_11);
                            dayOaList.add(newOaBusiness);
                        }
                    }
                    appAttendReportDto.setOaList(dayOaList);
                }
            }
        }
        reportDto.setDayReportList(dayReportList);
        return reportDto;
    }

}
