package com.bcxin.platform.service.attend;

import java.util.List;
import com.bcxin.platform.domain.attend.AttendWifi;

/**
 * 考勤wifiService接口
 * 
 * @author lin
 * @date 2022-04-09
 */
public interface AttendWifiService{

    /**
     * 查询考勤wifi
     * 
     * @param id 考勤wifiID
     * @return 考勤wifi
     */
    AttendWifi findById(Long id);

    /**
     * 查询考勤wifi列表
     * 
     * @param attendWifi 考勤wifi
     * @return 考勤wifi集合
     */
    List<AttendWifi> selectList(AttendWifi attendWifi);


    /**
     * 编辑考勤wifi
     * 
     * @param attendWifi 考勤wifi
     * @return 结果
     */
    int update(AttendWifi attendWifi);

    /**
     * 批量删除考勤wifi
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤wifi信息
     * 
     * @param id 考勤wifiID
     * @return 结果
     */
    int deleteById(Long id);
}
