package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.dto.app.AppAttendShiftDto;
import com.bcxin.platform.dto.attend.AttendShiftDto;

import java.util.List;

/**
 * 考勤班次Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendShiftService{

    /**
     * 查询考勤班次
     * 
     * @param id 考勤班次ID
     * @return 考勤班次
     */
    AttendShift findById(Long id);

    /**
     * 查询考勤班次列表
     * 
     * @param attendShift 考勤班次
     * @return 考勤班次集合
     */
    List<AttendShiftDto> selectList(AttendShiftDto attendShift);


    void validateData(AttendShift attendShift);

    /**
     * 编辑考勤班次
     * 
     * @param attendShift 考勤班次
     * @return 结果
     */
    int update(AttendShift attendShift);

    /**
     * 批量删除考勤班次
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    int saveBatch(List<AttendShift> shiftList);

    List<AppAttendShiftDto> findByAttendId(AttendShiftDto attendShift);
}
