package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendCalendarRestDetail;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;

import java.util.List;

/**
 * 考勤打卡日历套-日历-假日Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendCalendarRestDetailService {

    /**
     * 查询考勤打卡日历套-日历-假日
     * 
     * @param id 考勤打卡日历套-日历-假日ID
     * @return 考勤打卡日历套-日历-假日
     */
    AttendCalendarRestDetail findById(Long id);

    /**
     * 查询考勤打卡日历套-日历-假日列表
     * 
     * @param attendCalendarRestDetail 考勤打卡日历套-日历-假日
     * @return 考勤打卡日历套-日历-假日集合
     */
    List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarRestDetail);


    /**
     * 编辑考勤打卡日历套-日历-假日
     * 
     * @param attendCalendarRestDetail 考勤打卡日历套-日历-假日
     * @return 结果
     */
    int update(AttendCalendarRestDetail attendCalendarRestDetail);

    /**
     * 批量删除考勤打卡日历套-日历-假日
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤打卡日历套-日历-假日信息
     * 
     * @param id 考勤打卡日历套-日历-假日ID
     * @return 结果
     */
    int deleteById(Long id);
}
