package com.bcxin.platform.service.attend;

import java.util.List;
import com.bcxin.platform.domain.attend.AttendAddress;

/**
 * 考勤地点定位Service接口
 * 
 * @author lin
 * @date 2022-04-09
 */
public interface AttendAddressService{

    /**
     * 查询考勤地点定位
     * 
     * @param id 考勤地点定位ID
     * @return 考勤地点定位
     */
    AttendAddress findById(Long id);

    /**
     * 查询考勤地点定位列表
     * 
     * @param attendAddress 考勤地点定位
     * @return 考勤地点定位集合
     */
    List<AttendAddress> selectList(AttendAddress attendAddress);


    /**
     * 编辑考勤地点定位
     * 
     * @param attendAddress 考勤地点定位
     * @return 结果
     */
    int update(AttendAddress attendAddress);

    /**
     * 批量删除考勤地点定位
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤地点定位信息
     * 
     * @param id 考勤地点定位ID
     * @return 结果
     */
    int deleteById(Long id);
}
