package com.bcxin.platform.mapper.ins;


import com.bcxin.platform.domain.insurance.ComInsGuaProject;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface ComInsGuaProjectManageMapper {

    /**
     * 根据保险方案ID，查询出所有的保障项目
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:48
     * @param comInsId
     * @return
     */
    List<ComInsGuaProject> selectItemsById(@Param("comInsId") Long comInsId);

    /**
     * 根据业务日志ID，查询出新增待审核的所有的保障项目
     * @return
     */
    List<ComInsGuaProject> selectComInsAddVerifyProject(Long businessLogId);

    /**
     * 根据修改事件id，查询出修改待审核的所有的保障项目
     * @return
     */
    List<ComInsGuaProject> selectComInsUpdVerifyProject(Long insChangeEventId);


    /**
     * 根据保险id ，删除关联的保险责任
     * @param comInsId
     */
    void deleteOldComInsGuaProject(Long comInsId);

    /**
     * 批量插入保险责任
     *
     */
    void insertList(@Param("guaList")List<ComInsGuaProject> guaList);
}