package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.dto.app.AppAttendManageDto;
import com.bcxin.platform.dto.attend.AttendDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤套Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendMapper{

    /**
     * 查询考勤套
     * 
     * @param id 考勤套ID
     * @return 考勤套
     */
    Attend findById(Long id);

    /**
     * 查询考勤套列表
     * 
     * @param attend 考勤套
     * @return 考勤套集合
     */
    List<Attend> selectList(AttendDto attend);

    /**
     * 查询考勤套列表
     *
     * @param attend 考勤套
     * @return 考勤套集合
     */
    List<Attend> selectListForPer(AttendDto attend);

    List<Attend> selectListForChargePer(AttendDto attend);

    /**
     * 删除考勤套
     * 
     * @param id 考勤套ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤套
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attend
     * @return
     */
    int save(Attend attend);

    /****
     * 选择修改
     * @param attend
     * @return
     */
    int updateSelective(Attend attend);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<Attend> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<Attend> findByBatchId(@Param("list") List<Attend> list);

    List<Attend> findByArrIds(@Param("list")String[] ids);

    List<Attend> findUsedList(@Param("list")String[] ids);

    /**
     * 查询用户考勤套
     * @param perId
     * @return
     */
    Attend findByPerId(Long perId);

    Attend findbyName(String attendName);

    List<AppAttendManageDto> selectManageListForChargePer(AttendDto attend);
}
