package com.bcxin.platform.mapper.attend;

import java.util.List;
import org.apache.ibatis.annotations.Param;
import com.bcxin.platform.domain.attend.AttendChangeShift;

/**
 * 换班记录Mapper接口
 * 
 * @author lin
 * @date 2021-09-20
 */
public interface AttendChangeShiftMapper{

    /**
     * 查询换班记录
     * 
     * @param id 换班记录ID
     * @return 换班记录
     */
    AttendChangeShift findById(Long id);

    /**
     * 查询换班记录列表
     * 
     * @param attendChangeShift 换班记录
     * @return 换班记录集合
     */
    List<AttendChangeShift> selectList(AttendChangeShift attendChangeShift);

    /**
     * 删除换班记录
     * 
     * @param id 换班记录ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除换班记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendChangeShift
     * @return
     */
    int save(AttendChangeShift attendChangeShift);

    /****
     * 选择修改
     * @param attendChangeShift
     * @return
     */
    int updateSelective(AttendChangeShift attendChangeShift);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendChangeShift> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendChangeShift> findByBatchId(@Param("list") List<AttendChangeShift> list);

}
