package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 企业钱包账户交易记录
 *
 * @author llc
 * @date 2019-06-20
 */
@Data
@TableName("com_wallet_trade")
public class ComWalletTrade extends BaseEntity<ComWalletTrade> {

    /**
     * 企业钱包交易流水号
     */
    @ApiModelProperty(value = "企业钱包交易流水号")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comWalletTradeId;

    /**
     * 交易金额
     */
    @ApiModelProperty(value = "交易金额")
    private BigDecimal amount;

    /**
     * 业务交易流水号
     */
    @ApiModelProperty(value = "业务交易流水号")
    private String businessPartnerSeq;
    /**
     * 业务编码
     */
    @ApiModelProperty(value = "业务编码")
    private String businessCode;
    /**
     * 交易类型
     */
    @ApiModelProperty(value = "交易类型")
    private String tradeType;

    /**
     * 交易状态
     */
    @ApiModelProperty(value = "交易状态")
    private String tradeStatus;

    /**
     * 交易备注
     */
    private String comment;

    /**
     * 富民银行交易流水号
     */
    private String bankTradeNo;

    /**
     * 失败原因
     */
    @ApiModelProperty(value = "失败原因")
    private String errorMsg;


}