package com.bcxin.platform.domain.attend;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 类别对象 tb_attend_dict
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendDict extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 类别ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 名称 */
    @Excel(name = "名称")
    @NotBlank(message="名称不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String dictName;

    /** 类别  0请假1加班2公出*/
    @Excel(name = "类别")
    @NotBlank(message="类别不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String dictType;

    /** 是否启用 1是0否 */
    @Excel(name = "是否启用 1是0否")
    @NotBlank(message="是否启用不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String active;

    /** 是否必须上传附件 0非必须 1必须 */
    @Excel(name = "是否必须上传附件 0非必须 1必须")
    @NotBlank(message="是否必须上传附件不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String annex;

    /** 公司ID */
    @Excel(name = "公司ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="公司ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long comId;

    public static void main(String[] args) {
        AttendDict attendDict = new AttendDict();
        attendDict.setId(0L);
        attendDict.setDictName("");
        attendDict.setDictType("");
        attendDict.setActive("");
        attendDict.setAnnex("");
        attendDict.setComId(0L);
        attendDict.setSearchValue("");
        attendDict.setCreateBy("");
        attendDict.setCreateTime(new Date());
        attendDict.setUpdateBy("");
        attendDict.setUpdateTime(new Date());
        attendDict.setRemark("");
        attendDict.setIsDelete("");
        attendDict.setParams(Maps.newHashMap());

        System.out.println(JSON.toJSONString(attendDict));
    }
}
