package com.bcxin.platform.components;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.V5BusinessException;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Collections;

public interface JsonProvider {
    <T> T getData(String json, Class<T> tClass);

    <T> String getJson(T data);

    <T>Collection<T> getDataList(String json,Class<T> tClass);

    public static class JsonProviderImpl implements JsonProvider {
        @Override
        public <T> T getData(String json, Class<T> tClass) {
            try {
                return JSON.parseObject(json, tClass);
            } catch (Exception ex) {
                throw new V5BusinessException("JSON反序列化异常", ex);
            }
        }

        @Override
        public <T> String getJson(T data) {
            try {
                return JSON.toJSONString(data);
            } catch (Exception ex) {
                throw new V5BusinessException("JSON序列化异常", ex);
            }

        }

        @Override
        public <T> Collection<T> getDataList(String json, Class<T> tClass) {
            if (StringUtils.isEmpty(json)) {
                return Collections.EMPTY_LIST;
            }

            return JSON.parseArray(json, tClass);
        }
    }
}
