package com.bcxin.obpm.service.impl;

import com.bcxin.obpm.domain.UserDepartment;
import com.bcxin.obpm.mapper.UserDepartmentMapper;
import com.bcxin.obpm.service.UserDepartmentService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * v5人员部门Service业务层处理
 * 
 * @author lin
 * @date 2021-06-06
 */
@Service
public class UserDepartmentServiceImpl implements UserDepartmentService{

    @Resource
    private UserDepartmentMapper userDepartmentMapper;

    /**
     * 查询v5人员部门
     * 
     * @param id v5人员部门ID
     * @return v5人员部门
     */
    @Override
    public UserDepartment selectUserDepartmentById(String id){
        return userDepartmentMapper.selectUserDepartmentById(id);
    }

    /**
     * 查询v5人员部门列表
     * 
     * @param tlkIds v5人员Id
     * @return v5人员部门
     */
    @Override
    public List<UserDepartment> selectUserDepartmentList(List<String> tlkIds){
        return userDepartmentMapper.selectUserDepartmentList(tlkIds);
    }

    @Override
    public List<UserDepartment> selectUserDepartmentByUserId(String userId) {
        return userDepartmentMapper.selectUserDepartmentByUserId(userId);
    }

}
