package com.bcxin.oaflow.service.impl;

import com.bcxin.oaflow.domain.LeaveApplication;
import com.bcxin.oaflow.mapper.LeaveApplicationMapper;
import com.bcxin.oaflow.service.LeaveApplicationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 请假Service业务层处理
 * 
 * @author lin
 * @date 2021-09-01
 */
@Service
public class LeaveApplicationServiceImpl implements LeaveApplicationService {

    @Autowired
    private LeaveApplicationMapper leaveApplicationMapper;

    /**
     * 查询请假
     * 
     * @param id 请假ID
     * @return 请假
     */
    @Override
    public LeaveApplication findById(String id){
        return leaveApplicationMapper.findById(id);
    }

    /**
     * 查询请假列表
     * 
     * @param tlkPerIds
     * @param schedulDate
     * @return 请假
     */
    @Override
    public List<LeaveApplication> selectList(List<String> tlkPerIds,String schedulDate){
        return leaveApplicationMapper.selectList(tlkPerIds,schedulDate);
    }

}
