package com.bcxin.oaflow.service.impl;

import com.bcxin.oaflow.domain.BusinessTravel;
import com.bcxin.oaflow.mapper.BusinessTravelMapper;
import com.bcxin.oaflow.service.BusinessTravelService;
import com.bcxin.platform.common.utils.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 出差Service业务层处理
 * 
 * @author lin
 * @date 2021-09-01
 */
@Service
public class BusinessTravelServiceImpl implements BusinessTravelService {

    @Autowired
    private BusinessTravelMapper businessTravelMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询出差
     * 
     * @param id 出差ID
     * @return 出差
     */
    @Override
    public BusinessTravel findById(String id){
        return businessTravelMapper.findById(id);
    }

    /**
     * 查询出差列表
     *
     * @param tlkPerIds
     * @param schedulDate
     * @return 出差
     */
    @Override
    public List<BusinessTravel> selectList(List<String> tlkPerIds,String schedulDate){
        return businessTravelMapper.selectList(tlkPerIds,schedulDate);
    }

}
