/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.config;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Configuration
public class LogRecordAspect {
    private static final Logger logger = LoggerFactory.getLogger(LogRecordAspect.class);

    @Pointcut(value="execution(* com.bcxin.platform.web.controller..*.*(..))")
    public void excudeService() {
    }

    private static String getMethodName(String fildeName) throws Exception {
        byte[] items = fildeName.getBytes();
        if (Character.isLowerCase(items[0])) {
            items[0] = (byte)((char)items[0] - 97 + 65);
        }
        return new String(items);
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String queryString = JSONObject.toJSONString((Object)request.getParameterMap());
        String createBy = request.getAttribute("createBy") == null || request.getAttribute("createBy").equals("") ? null : request.getAttribute("createBy").toString();
        Long comId = request.getAttribute("comId") == null || request.getAttribute("comId").equals("") ? null : Long.valueOf(request.getAttribute("comId").toString());
        logger.info("\u8bf7\u6c42\u5f00\u59cb, \u5404\u4e2a\u53c2\u6570, url: {}, method: {}, uri: {}, params: {}", new Object[]{url, method, uri, queryString});
        if (createBy != null) {
            Object[] args;
            for (Object obj : args = pjp.getArgs()) {
                for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    Field[] fields = clazz.getDeclaredFields();
                    if (fields == null || fields.length <= 0) continue;
                    for (Field item : fields) {
                        Method m;
                        if (item.getName().equals("createBy")) {
                            item.setAccessible(true);
                            try {
                                if (item.getGenericType().toString().equals("class java.lang.Long")) {
                                    item.set(obj, Long.parseLong(createBy));
                                } else {
                                    item.set(obj, createBy);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (item.getName().equals("updateBy")) {
                            item.setAccessible(true);
                            try {
                                if (item.getGenericType().toString().equals("class java.lang.Long")) {
                                    item.set(obj, Long.parseLong(createBy));
                                } else {
                                    item.set(obj, createBy);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (item.getName().equals("comId") && comId != null && item.getGenericType().toString().equals("class java.lang.Long")) {
                            item.setAccessible(true);
                            try {
                                item.set(obj, comId);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!item.getGenericType().toString().equals("class java.lang.String") || Modifier.isFinal(item.getModifiers()) || Modifier.isStatic(item.getModifiers()) || (m = obj.getClass().getMethod("get" + LogRecordAspect.getMethodName(item.getName()), new Class[0])) == null || m.invoke(obj, new Object[0]) == null) continue;
                        item.setAccessible(true);
                        try {
                            item.set(obj, m.invoke(obj, new Object[0]).toString().trim());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        Object result = pjp.proceed();
        return result;
    }
}

