/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.cache;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.util.AESUtil;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.ResultJson;
import com.bcxin.platform.util.huawei.HttpBuildUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="taskCacheService")
public class TaskCacheServiceImpl
implements TaskCacheService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private RedisUtil redisUtil;

    public static Result bbdLogin(String comIdEncode, String configURL) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("comId", comIdEncode);
        String url = configURL + "/user/saas/com/login.json";
        ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
        if (resultJson != null && resultJson.isSuccessful()) {
            return Result.success((String)"", (Object)resultJson.getData());
        }
        return Result.fail((String)resultJson.getMsg());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getBbdAccessToken(Long comId, String platUrl) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":bbdToken" + comId;
        String accessToken = "";
        if (this.stringRedisTemplate.hasKey((Object)redisKey) != false) return (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        String comIdEncode = "";
        try {
            comIdEncode = AESUtil.encode(comId.toString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        Result result = TaskCacheServiceImpl.bbdLogin(comIdEncode, platUrl);
        if (!result.getRetType().equals("0")) throw new V5BusinessException("-2", "\u767b\u5f55\u516c\u5b89\u5b50\u7ad9\u5931\u8d25");
        Map resultMap = (Map)JSON.parseObject((String)result.getData().toString(), Map.class);
        if (resultMap == null) return accessToken;
        accessToken = resultMap.get("sid").toString();
        Long expiresTime = 2588400L;
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)accessToken, expiresTime.longValue(), TimeUnit.SECONDS);
        return accessToken;
    }

    @Override
    public void setActiveCodeSerial(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":ActiveCodeSerial:" + key), (Object)value, 600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getActiveCodeSerial(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":ActiveCodeSerial:" + key));
    }

    @Override
    public void setSMSPhoneCount(String key, int count) {
        if (count == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PhoneCount:" + key), (Object)(count + 1 + ""), 86400000L, TimeUnit.MILLISECONDS);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PhoneCount:" + key), (Object)(count + 1 + ""), 0L);
        }
    }

    @Override
    public int getSMSPhoneCount(String key) {
        String count = (String)this.stringRedisTemplate.opsForValue().get((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PhoneCount:" + key));
        if (StringUtils.isEmpty((String)count)) {
            return 0;
        }
        return Integer.parseInt(count);
    }

    @Override
    public void setPhoneAuthCode(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PhoneAuthCode:" + key + value), (Object)value, 600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getPhoneAuthCode(String key, String value) {
        if (value.equalsIgnoreCase("888888")) {
            return value;
        }
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PhoneAuthCode:" + key + value));
        return result;
    }

    @Override
    public String getHuaweiMeetAccessToken(String userName, String passWord, Long perId) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":huaweiMeet" + perId;
        String accessToken = "";
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            Map resultMap;
            String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("account", userName);
            map.put("clientType", 0);
            map.put("createTokenType", 0);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/acs/auth/account";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            if (response.getHttpCode() == 200 && (resultMap = (Map)JSON.parseObject((String)response.getEntity().toString(), Map.class)) != null) {
                accessToken = resultMap.get("accessToken").toString();
                String expires_in = resultMap.get("validPeriod").toString();
                Long expiresTime = Long.parseLong(expires_in) - 3600L;
                if (expiresTime > 0L) {
                    this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)accessToken, expiresTime.longValue(), TimeUnit.SECONDS);
                }
            }
        } else {
            accessToken = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
            this.logger.info("\u4ece\u7f13\u5b58\u4e2d\u62ffaccessToken:" + accessToken);
        }
        return accessToken;
    }

    @Override
    public String getComManageHuaweiMeetAccessToken(String userName, String passWord, Long comId) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":huaweiMeetCom" + comId;
        String accessToken = "";
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            Map resultMap;
            String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("account", userName);
            map.put("clientType", 0);
            map.put("createTokenType", 0);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/acs/auth/account";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            System.out.println("getComManageHuaweiMeetAccessToken => response:" + response.toString());
            if (response.getHttpCode() == 200 && (resultMap = (Map)JSON.parseObject((String)response.getEntity().toString(), Map.class)) != null) {
                accessToken = resultMap.get("accessToken").toString();
                String expires_in = resultMap.get("validPeriod").toString();
                Long expiresTime = Long.parseLong(expires_in) - 3600L;
                if (expiresTime > 0L) {
                    this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)accessToken, expiresTime.longValue(), TimeUnit.SECONDS);
                }
            }
        } else {
            accessToken = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
            this.logger.info("\u4ece\u7f13\u5b58\u4e2d\u62ffaccessToken:" + accessToken);
        }
        return accessToken;
    }

    @Override
    public boolean setRoomPerNum(String room, String count) {
        if (StringUtils.isNotEmpty((String)count) && StringUtils.isNotEmpty((String)room)) {
            String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":room_" + room;
            this.logger.info("\u8bbe\u7f6e\u623f\u95f4\u4eba\u6570\uff08" + redisKey + "\uff09:" + count);
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)count, 86400000L, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public String getRoomPerNum(String room) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":room_" + room;
        String count = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        this.logger.info("\u83b7\u53d6\u623f\u95f4\u4eba\u6570\uff08" + redisKey + "\uff09:" + count);
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":room_" + room));
    }

    @Override
    public void delRoom(String room) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":room_" + room;
        this.logger.info("\u89e3\u6563\u623f\u95f4\uff08" + redisKey + "\uff09--------------");
        this.getRoomPerNum(room);
        this.stringRedisTemplate.delete((Object)redisKey);
    }
}

