package com.teemlink.pm.task.controller;

import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SequenceException;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.sequence.Sequence;
import com.teemlink.pm.base.controller.BaseController;
import com.teemlink.pm.project.model.Project;
import com.teemlink.pm.project.service.ProjectProcess;
import com.teemlink.pm.project.service.ProjectProcessBean;
import com.teemlink.pm.task.model.Follower;
import com.teemlink.pm.task.model.Remark;
import com.teemlink.pm.task.model.SubTask;
import com.teemlink.pm.task.model.Task;
import com.teemlink.pm.task.service.TaskProcess;
import com.teemlink.pm.task.service.TaskProcessBean;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller(value = "TaskAction")
@RequestMapping(value = "/pm/task")
@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class TaskController extends BaseController<Task> {

	/**
	 * 下载文件流
	 */
	private InputStream inputStream;

	/**
	 * 下载文件名
	 */
	private String filename;

	@Autowired
	protected HttpServletRequest request;

	@Autowired
	protected HttpServletResponse response;

	@Autowired
	protected HttpSession session;

	public TaskController() {
		super();
		content = new Task();
		process = new TaskProcessBean();
	}

	@RequestMapping(value = "/createTaskId.action")
	public Map<String, Object> doNewTaskId() throws SequenceException {
		String TaskId = Sequence.getSequence();
		return addActionResult(true, "添加成功", TaskId);
	}

	@RequestMapping(value = "/create.action")
	public Map<String, Object> doCreate() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			Task task = (Task) getContent();

			// 关注人集合
			String _followers = params.getParameterAsString("followers");
			if (_followers != null && !"".equals(_followers)) {
				Collection<Follower> followers = new ArrayList<Follower>();
				JSONArray jsonArray = JSONArray.fromObject(_followers);
				if (jsonArray != null && !jsonArray.isEmpty()) {
					Follower follower;
					for (int index = 0; index < jsonArray.size(); index++) {
						JSONObject item = jsonArray.getJSONObject(index);
						follower = new Follower();
						follower.setUserId(item.getString("userId"));
						follower.setUserName(item.getString("userName"));
						follower.setDomainId(user.getDomainid());
						followers.add(follower);
					}
				}
				task.setFollowers(followers);
			}

			// 创建任务
			task = (Task) ((TaskProcess) process).doCreate(task, user);
			return addActionResult(true, "添加成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/view.action")
	public Map<String, Object> doView() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");

			Task task = (Task) process.doView(id);
			return addActionResult(true, null, task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 更新任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/update.action")
	public Map<String, Object> doUpdate() {
		try {
			Task vo = (Task) getContent();
			WebUser user = getUser();
			if (!StringUtil.isBlank(vo.getId())) {
				Task task = ((TaskProcess) process).doUpdate(vo, user);
				return addActionResult(true, "修改成功", task);
			} else {
				return addActionResult(false, "修改任务失败", vo);
			}
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 更新任务基础字段
	 * 
	 * @return
	 */
	@RequestMapping(value = "/simpleUpdate.action")
	public Map<String, Object> doSimpleUpdate() {
		WebUser user = getUser();
		ParamsTable params = getParams();
		String id = params.getParameterAsString("id");
		String updateField = params.getParameterAsString("updateField");
		String updateValue = params.getParameterAsString("updateValue");

		try {
			Task task = (Task) ((TaskProcess) process).doSimpleUpdate(id, updateField, updateValue, user);
			return addActionResult(true, "修改成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/updateEndDate.action")
	public Map<String, Object> doUpdateEndDate() {
		WebUser user = getUser();
		ParamsTable params = getParams();
		String id = params.getParameterAsString("id");
		int delta = params.getParameterAsInteger("delta");

		try {
			Task t = (Task) process.doView(id);
			if (t == null)
				throw new OBPMValidateException("找不到对象");

			Calendar calendar = Calendar.getInstance();
			calendar.setTime(t.getEndDate());
			calendar.add(Calendar.DAY_OF_YEAR, delta);

			Task task = (Task) ((TaskProcess) process).doSimpleUpdate(id, "endDate",
					new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime()), user);
			return addActionResult(true, "修改成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/updateDate.action")
	public Map<String, Object> doUpdateDate() {
		ParamsTable params = getParams();
		String id = params.getParameterAsString("id");
		int delta = params.getParameterAsInteger("delta");

		try {
			Task task = (Task) process.doView(id);
			if (task == null)
				throw new OBPMValidateException("找不到对象");

			Calendar calendar = Calendar.getInstance();
			calendar.setTime(task.getEndDate());
			calendar.add(Calendar.DAY_OF_YEAR, delta);
			task.setEndDate(calendar.getTime());

			calendar.setTime(task.getStartDate());
			calendar.add(Calendar.DAY_OF_YEAR, delta);
			task.setStartDate(calendar.getTime());

			process.doUpdate(task);
			return addActionResult(true, "修改成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 添加项目关注人
	 * 
	 * @return
	 */
	@RequestMapping(value = "/addFollowers.action")
	@SuppressWarnings("unchecked")
	public Map<String, Object> doAddFollowers() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			String taskId = params.getParameterAsString("id");
			String _followers = params.getParameterAsString("followers");
			Collection<Follower> followers = new ArrayList<Follower>();

			JSONArray jsonArray = JSONArray.fromObject(_followers);
			for (Iterator<JSONObject> iterator = jsonArray.iterator(); iterator.hasNext();) {
				JSONObject item = iterator.next();
				Follower follower = new Follower();
				follower.setUserId(item.getString("userId"));
				follower.setUserName(item.getString("userName"));
				follower.setDomainId(user.getDomainid());
				followers.add(follower);
			}

			((TaskProcess) process).addFollowers(taskId, followers, user);
			return addActionResult(true, "添加成功", followers);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 移除项目关注人
	 * 
	 * @return
	 */
	@RequestMapping(value = "/removeFollower.action")
	public Map<String, Object> doRemoveFollower() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			String taskId = params.getParameterAsString("id");
			String userId = params.getParameterAsString("followerId");
			String userName = params.getParameterAsString("followerName");

			((TaskProcess) process).deleteFollower(userId, userName, taskId, user);
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 关注任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/follow.action")
	public Map<String, Object> doFollow() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			String taskId = params.getParameterAsString("id");
			((TaskProcess) process).doFollow(taskId, user);
			return addActionResult(true, "关注成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 取消关注任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/unfollow.action")
	public Map<String, Object> doUnFollow() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			String taskId = params.getParameterAsString("id");

			((TaskProcess) process).doUnFollow(taskId, user);
			return addActionResult(true, "取消关注成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 完成任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/complateTask.action")
	public Map<String, Object> doComplete() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			String taskId = params.getParameterAsString("id");

			((TaskProcess) process).doComplete(taskId, user);
			return addActionResult(true, "", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 更新任务的状态
	 * 
	 * @return
	 */
	@RequestMapping(value = "/doUpdateTaskStatus.action")
	public Map<String, Object> doUpdateTaskStatus() {
		WebUser user = getUser();
		ParamsTable params = getParams();
		String id = params.getParameterAsString("id");
		Integer status = params.getParameterAsInteger("status");
		if ("null".equals(status)) { // 任务默认为新建
			status = Task.STATUS_NEW;
		}

		try {
			Task task_test = (Task) process.doView(id);
			if (task_test == null)
				throw new OBPMValidateException("找不到对象");

			Task task = (Task) ((TaskProcess) process).doUpdateTaskStatus(id, status, user);
			return addActionResult(true, "修改成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 重做任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/redoTask.action")
	public Map<String, Object> doRedoTask() {
		try {
			WebUser user = getUser();
			ParamsTable params = getParams();
			String taskId = params.getParameterAsString("id");

			((TaskProcess) process).redoTask(taskId, user);
			return addActionResult(true, "", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 删除任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/remove.action")
	public Map<String, Object> doDelete() {

		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");

			((TaskProcess) process).doRemove(id);
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 添加子任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/createSubTask.action")
	public Map<String, Object> doCreateSubTask() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String subTaskName = params.getParameterAsString("name");

			SubTask subTask = new SubTask(subTaskName);

			((TaskProcess) process).createSubTask(id, subTask, user);
			return addActionResult(true, "添加成功", subTask);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 删除子任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/removeSubTask.action")
	public Map<String, Object> doDeleteSubTask() {

		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String subTaskId = params.getParameterAsString("subTaskId");

			((TaskProcess) process).removeSubTask(id, subTaskId, user);
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 完成子任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/complateSubTask.action")
	public Map<String, Object> doCompleteSubTask() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String subTaskId = params.getParameterAsString("subTaskId");

			SubTask subTask = ((TaskProcess) process).completeSubTask(id, subTaskId, user);
			return addActionResult(true, "修改成功", subTask);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 重做子任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/redoSubTask.action")
	public Map<String, Object> doRedoSubTask() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String subTaskId = params.getParameterAsString("subTaskId");

			SubTask subTask = ((TaskProcess) process).redoSubTask(id, subTaskId, user);
			return addActionResult(true, "修改成功", subTask);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 保存子任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateSubTask.action")
	public Map<String, Object> doUpdateSubTask() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String subTaskId = params.getParameterAsString("subTaskId");
			String subTaskName = params.getParameterAsString("name");

			SubTask subTask = ((TaskProcess) process).updateSubTask(id, subTaskId, subTaskName, user);
			return addActionResult(true, "修改成功", subTask);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 添加备注
	 * 
	 * @return
	 */
	@RequestMapping(value = "/createRemark.action")
	public Map<String, Object> doCreateRemark() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String remarkContent = params.getParameterAsString("content");
			Remark remark = new Remark(remarkContent, user.getName());
			remark.setUserId(user.getId());

			((TaskProcess) process).createRemark(id, remark, user);
			return addActionResult(true, "添加成功", remark);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 删除备注
	 * 
	 * @return
	 */
	@RequestMapping(value = "/removeRemark.action")
	public Map<String, Object> doDeleteRemark() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String remarkId = params.getParameterAsString("remarkId");

			((TaskProcess) process).removeRemark(id, remarkId, user);
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 保存备注
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateRemark.action")
	public Map<String, Object> doUpdateRemark() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String remarkId = params.getParameterAsString("remarkId");
			String remarkContnet = params.getParameterAsString("content");

			Remark remark = ((TaskProcess) process).updateRemark(id, remarkId, remarkContnet, user);
			return addActionResult(true, "修改成功", remark);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/query.action")
	public Map<String, Object> doQuery() {
		try {
			ParamsTable params = getParams();
			String name = params.getParameterAsString("name");
			int status = params.getParameterAsInteger("status");
			String type = params.getParameterAsString("type");
			String currDate = params.getParameterAsString("currDate");
			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("dateRangeType");
			Integer page = params.getParameterAsInteger("_currpage");
			Integer lines = params.getParameterAsInteger("_rowcount");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 30;
			WebUser user = getUser();

			Collection<Task> list = null;
			if ("my".equals(type)) {
				list = ((TaskProcess) process).queryMyTasks(name, status, currDate, dateRangeType, user);
			} else if ("follow".equals(type)) {
				list = ((TaskProcess) process).queryMyFollowTasks(name, status, currDate, dateRangeType, page, lines,
						user);
			} else if ("entrust".equals(type)) {
				list = ((TaskProcess) process).queryMyEntrustTasks(name, status, currDate, dateRangeType, page, lines,
						user);
			} else {
				throw new OBPMValidateException("查询条件不匹配");
			}

			return addActionResult(true, "", list);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 查询我的任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryMyTasks.action")
	public Map<String, Object> doQueryMyTasks() {
		try {
			ParamsTable params = getParams();
			String name = params.getParameterAsString("name");
			String tmp_status = params.getParameterAsString("status");
			int status = Task.STATUS_NULL;
			if (!StringUtil.isBlank(tmp_status)) {
				status = new Integer(tmp_status);
			}
			String currDate = params.getParameterAsString("currDate");
			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("dateRangeType");

			WebUser user = getUser();
			Collection<Task> list = ((TaskProcess) process).queryMyTasks(name, status, currDate, dateRangeType, user);
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 查询我的任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryMyTasks4CalendarView.action")
	public Map<String, Object> doQueryMyTasks4CalendarView() {
		try {
			ParamsTable params = getParams();
			String name = params.getParameterAsString("name");
			String startDate = params.getParameterAsString("startDate");
			String endDate = params.getParameterAsString("endDate");
			String tmp_status = params.getParameterAsString("status");
			int status = Task.STATUS_NULL;
			if (!StringUtil.isBlank(tmp_status)) {
				status = new Integer(tmp_status);
			}

			WebUser user = getUser();
			Collection<Task> list = ((TaskProcess) process).queryMyTasks4CalendarView(name, status, startDate, endDate,
					user);
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 查询我关注的任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryMyFollowTasks.action")
	public Map<String, Object> doQueryMyFollowTasks() {
		try {
			ParamsTable params = getParams();
			String name = params.getParameterAsString("name");

			String tmp_status = params.getParameterAsString("status");
			int status = Task.STATUS_NULL;
			if (!StringUtil.isBlank(tmp_status)) {
				status = new Integer(tmp_status);
			}
			String currDate = params.getParameterAsString("currDate");
			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("dateRangeType");

			Integer page = params.getParameterAsInteger("_currpage");
			Integer lines = params.getParameterAsInteger("_rowcount");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 30;

			WebUser user = getUser();
			Collection<Task> list = ((TaskProcess) process).queryMyFollowTasks(name, status, currDate, dateRangeType,
					page, lines, user);
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 根据项目查询任务集合
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryTasksByProject.action")
	public Map<String, Object> doQueryTasksByProject() {
		try {
			ParamsTable params = getParams();
			String projectId = params.getParameterAsString("projectId");
			String taskName = params.getParameterAsString("taskName");
			String executerId = params.getParameterAsString("executorId");
			String createrId = params.getParameterAsString("creatorId");
			String tmp_status = params.getParameterAsString("status");
			String overdueStatus = params.getParameterAsString("overdue");
			int status = Task.STATUS_ON;
			if (!StringUtil.isBlank(tmp_status)) {
				status = new Integer(tmp_status);
			}

			String tmp_level = params.getParameterAsString("level");
			int level = Task.LEVEL_NULL;
			if (!StringUtil.isBlank(tmp_level)) {
				level = new Integer(tmp_level);
			}

			String tag = params.getParameterAsString("tag");

			String currDate = params.getParameterAsString("nowDate");

			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("endDate");

			String orderName = params.getParameterAsString("orderName");
			String orderBy = params.getParameterAsString("orderBy");

			Integer page = params.getParameterAsInteger("pageNo");
			Integer lines = params.getParameterAsInteger("linesPerPage");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 30;

			WebUser user = getUser();

			DataPackage<Task> datas = ((TaskProcess) process).queryTasksByProject(projectId, taskName, status, level,
					executerId, createrId, currDate, dateRangeType, tag, orderName, orderBy, page, lines, overdueStatus,
					user);

			return addActionResult(true, "", datas);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 根据项目查询任务集合 status,level,executorId,creatorId,tag 参数可传入多个进行多选
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryTasksByProject4Multiselect.action")
	public Map<String, Object> doQueryTasksByProject4Multiselect() {
		try {
			ParamsTable params = getParams();
			String projectId = params.getParameterAsString("projectId");
			String taskName = params.getParameterAsString("taskName");
			String overdueStatus = params.getParameterAsString("overdue");

			// status参数处理
			List<Integer> statusArray = new ArrayList<Integer>();
			Integer[] status = {};
			String[] tmp_status = params.getParameterAsArray("status");
			if (tmp_status != null && tmp_status.length > 0) {
				for (String tmp_statu : tmp_status) {
					if (StringUtil.isNumber(tmp_statu)) {
						statusArray.add(Integer.valueOf(tmp_statu));
					}
				}
				status = statusArray.toArray(status);
			}

			// levels参数处理
			List<Integer> levelsArray = new ArrayList<Integer>();
			Integer[] levels = {};
			String[] tmp_levels = params.getParameterAsArray("level");
			if (tmp_levels != null && tmp_levels.length > 0) {
				for (String tmp_level : tmp_levels) {
					if (StringUtil.isNumber(tmp_level)) {
						levelsArray.add(Integer.valueOf(tmp_level));
					}
				}
				levels = levelsArray.toArray(levels);
			}

			// executerIds参数处理
			List<String> executerArray = new ArrayList<String>();
			String[] executerIds = {};
			String[] tmp_executerIds = params.getParameterAsArray("executorId");
			if (tmp_executerIds != null && tmp_executerIds.length > 0) {
				for (String tmp_executerId : tmp_executerIds) {
					if (!StringUtil.isBlank(tmp_executerId)) {
						executerArray.add(tmp_executerId);
					}
				}
				executerIds = executerArray.toArray(executerIds);
			}

			// createrIds参数处理
			List<String> createArray = new ArrayList<String>();
			String[] createrIds = {};
			String[] tmp_createrIds = params.getParameterAsArray("creatorId");
			if (tmp_createrIds != null && tmp_createrIds.length > 0) {
				for (String tmp_createId : tmp_createrIds) {
					if (!StringUtil.isBlank(tmp_createId)) {
						createArray.add(tmp_createId);
					}
				}
				createrIds = createArray.toArray(createrIds);
			}

			// tags参数处理
			List<String> tagArray = new ArrayList<String>();
			String[] tags = {};
			String[] tmp_tags = params.getParameterAsArray("tag");
			if (tmp_tags != null && tmp_tags.length > 0) {
				for (String tmp_tag : tmp_tags) {
					if (!StringUtil.isBlank(tmp_tag)) {
						tagArray.add(tmp_tag);
					}
				}
				tags = tagArray.toArray(tags);
			}

			String currDate = params.getParameterAsString("nowDate");

			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("endDate");

			String orderName = params.getParameterAsString("orderName");
			String orderBy = params.getParameterAsString("orderBy");

			Integer page = params.getParameterAsInteger("pageNo");
			Integer lines = params.getParameterAsInteger("linesPerPage");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 15;

			WebUser user = getUser();

			DataPackage<Task> datas = ((TaskProcess) process).queryTasksByProject(projectId, taskName, status, levels,
					executerIds, createrIds, currDate, dateRangeType, tags, orderName, orderBy, page, lines,
					overdueStatus, user);

			return addActionResult(true, "", datas);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 根据项目查询任务集合
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryTasksByTag.action")
	public Map<String, Object> doQueryTasksByTag() {
		try {
			ParamsTable params = getParams();
			String tagName = params.getParameterAsString("tagName");
			String name = params.getParameterAsString("name");
			int status = params.getParameterAsInteger("status");
			String currDate = params.getParameterAsString("currDate");
			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("dateRangeType");

			Integer page = params.getParameterAsInteger("_currpage");
			Integer lines = params.getParameterAsInteger("_rowcount");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 30;

			WebUser user = getUser();
			Collection<Task> list = ((TaskProcess) process).queryTasksByTag(tagName, name, status, currDate,
					dateRangeType, page, lines, user);
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 添加任务标签
	 * 
	 * @return
	 */
	@RequestMapping(value = "/addTaskTag.action")
	public Map<String, Object> doAddTaskTag() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String tagName = params.getParameterAsString("tagName");
			((TaskProcess) process).addTag(id, tagName, user);
			Task task = (Task) ((TaskProcess) process).doView(id);
			return addActionResult(true, "添加成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 删除任务标签
	 * 
	 * @return
	 */
	@RequestMapping(value = "/removeTaskTag.action")
	public Map<String, Object> doRemoveTaskTag() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String tagName = params.getParameterAsString("tagName");

			((TaskProcess) process).removeTag(id, tagName, user);
			Task task = (Task) ((TaskProcess) process).doView(id);
			return addActionResult(true, "移除成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/setProject.action")
	public Map<String, Object> doSetProject() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			String projectId = params.getParameterAsString("projectId");
			String projectName = params.getParameterAsString("projectName");

			Task task = ((TaskProcess) process).setProject(id, projectId, projectName, user);
			return addActionResult(true, "添加成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/removeProject.action")
	public Map<String, Object> doRemoveProject() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String id = params.getParameterAsString("id");
			((TaskProcess) process).removeProject(id, user);
			return addActionResult(true, "移除成功", null);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/updateTaskExecutor.action")
	public Map<String, Object> doUpdateTaskExecutor() {
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();

			String id = params.getParameterAsString("id");
			String executorId = params.getParameterAsString("executorId");
			String executorName = params.getParameterAsString("executorName");

			Task task = ((TaskProcess) process).updateTaskExecutor(id, executorId, executorName, user);
			return addActionResult(true, "修改成功", task);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/getUsers.action")
	public Map<String, Object> doGetUsers() {
		try {
			WebUser user = getUser();
			UserProcess userPorcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);

			Collection<UserVO> users = userPorcess.queryByDomain(user.getDomainid());
			ArrayList<UserVO> list = new ArrayList<UserVO>();
			for (UserVO u : users) {
				if (u.getStatus()==1) {
					list.add(u);
				}
			}
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/deleteAttachment.action")
	public Map<String, Object> doDeleteAttachment() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String key = params.getParameterAsString("key");
			WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
			ServletContext servletContext = webApplicationContext.getServletContext();
			String realPath = servletContext.getRealPath("");// 服务器目录的绝对路径
			String savePath = null;
			Task task = (Task) process.doView(id);
			String attachment = task.getAttachment();
			JSONObject attachmentJson = JSONObject.fromObject(attachment);
			if (attachmentJson.getJSONObject(key).containsKey("url")) {
				savePath = realPath + "\\" + attachmentJson.getJSONObject(key).getString("url");
			} else {// 兼容旧数据
				savePath = realPath + "\\task\\" + task.getId(); // 存放此文件的绝对路径
			}
			task = ((TaskProcess) process).deleteAttachment(id, key);
			File file = new File(savePath);
			File temp = null;
			File[] filelist = file.listFiles();
			for (int i = 0; i < filelist.length; i++) {
				temp = filelist[i];
				if (temp.getName().startsWith(key) || temp.getName().indexOf(key) > 0) {
					temp.delete();// 删除文件}
				}
			}
			return addActionResult(true, null, "");
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value = "/download.action")
	public ResponseEntity<byte[]> doDownload() throws Exception {
		HttpHeaders headers = new HttpHeaders();
		File file = null;
		ParamsTable params = getParams();
		String taskid = params.getParameterAsString("taskid");
		String id = params.getParameterAsString("id");
		if (!StringUtil.isBlank(id)) {
			WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
			ServletContext servletContext = webApplicationContext.getServletContext();
			String realPath = servletContext.getRealPath("");
			Task task = (Task) process.doView(taskid);
			String attachment = task.getAttachment();
			JSONObject attachmentJson = JSONObject.fromObject(attachment);
			String name = attachmentJson.getJSONObject(id).getString("name");
			filename = new String(name.getBytes(), "ISO8859-1");
			String ext = filename.substring(filename.lastIndexOf("."));
			String savePath = null;
			headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
			headers.setContentDispositionFormData("attachment", filename);
			if (attachmentJson.getJSONObject(id).containsKey("url")) {
				savePath = realPath + File.separator + attachmentJson.getJSONObject(id).getString("url");
			} else {// 兼容旧数据
				savePath = realPath + File.separator + "task" + File.separator + taskid;
			}
			file = new File(savePath + File.separator + id + ext);
			if (file == null || !file.exists())
				throw new Exception("找不到文件！");
		}

		return new ResponseEntity<byte[]>(File2byte(file),headers, HttpStatus.CREATED);
	}

	public static byte[] File2byte(File file) {
		byte[] buffer = null;
		try
		{
			FileInputStream fis = new FileInputStream(file);
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			byte[] b = new byte[1024];
			int n;
			while ((n = fis.read(b)) != -1)
			{
				bos.write(b, 0, n);
			}
			fis.close();
			bos.close();
			buffer = bos.toByteArray();
		}
		catch (FileNotFoundException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		return buffer;
	}

	public InputStream getInputStream() {
		return inputStream;
	}

	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * 根据项目查询任务集合
	 * 
	 * @return
	 */
	@RequestMapping(value = "/queryTasks.action")
	public Map<String, Object> doQueryTasks() {
		try {
			ParamsTable params = getParams();
			String projectId = params.getParameterAsString("projectId");
			String taskName = params.getParameterAsString("taskName");
			String executerId = params.getParameterAsString("executorId");
			String createrId = params.getParameterAsString("creatorId");
			Integer status;
			String _status = params.getParameterAsString("status");
			if (StringUtil.isBlank(_status)) {
				status = null;
			} else {
				status = params.getParameterAsInteger("status");
			}
			String overdueStatus = params.getParameterAsString("overdue");
			Integer level = params.getParameterAsInteger("level");
			String _level = params.getParameterAsString("level");
			if (StringUtil.isBlank(_level)) {
				level = null;
			} else {
				level = params.getParameterAsInteger("level");
			}
			String tag = params.getParameterAsString("tag");

			String currDate = params.getParameterAsString("nowDate");

			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("endDate");

			String orderName = params.getParameterAsString("orderName");
			String orderBy = params.getParameterAsString("orderBy");

			Integer page = params.getParameterAsInteger("pageNo");
			Integer lines = params.getParameterAsInteger("linesPerPage");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 100;

			WebUser user = getUser();

			DataPackage<Task> datas = ((TaskProcess) process).queryTasks(projectId, taskName, status, level, executerId,
					createrId, currDate, dateRangeType, tag, orderName, orderBy, page, lines, overdueStatus, user);

			return addActionResult(true, "", datas);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 以excel的形式导出任务详细信息列表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/excelExportTask.action")
	public void excelExportTask() {
		try {
			ParamsTable params = getParams();
			String projectId = params.getParameterAsString("projectId");
			String taskName = params.getParameterAsString("taskName");
			String overdueStatus = params.getParameterAsString("overdue");

			// status参数处理
			List<Integer> statusArray = new ArrayList<Integer>();
			Integer[] status = {};
			String[] tmp_status = params.getParameterAsArray("status");
			if (tmp_status != null && tmp_status.length > 0) {
				for (String tmp_statu : tmp_status) {
					if (StringUtil.isNumber(tmp_statu)) {
						statusArray.add(Integer.valueOf(tmp_statu));
					}
				}
				status = statusArray.toArray(status);
			}

			// levels参数处理
			List<Integer> levelsArray = new ArrayList<Integer>();
			Integer[] levels = {};
			String[] tmp_levels = params.getParameterAsArray("level");
			if (tmp_levels != null && tmp_levels.length > 0) {
				for (String tmp_level : tmp_levels) {
					if (StringUtil.isNumber(tmp_level)) {
						levelsArray.add(Integer.valueOf(tmp_level));
					}
				}
				levels = levelsArray.toArray(levels);
			}

			// executerIds参数处理
			List<String> executerArray = new ArrayList<String>();
			String[] executerIds = {};
			String[] tmp_executerIds = params.getParameterAsArray("executorId");
			if (tmp_executerIds != null && tmp_executerIds.length > 0) {
				for (String tmp_executerId : tmp_executerIds) {
					if (!StringUtil.isBlank(tmp_executerId)) {
						executerArray.add(tmp_executerId);
					}
				}
				executerIds = executerArray.toArray(executerIds);
			}

			// createrIds参数处理
			List<String> createArray = new ArrayList<String>();
			String[] createrIds = {};
			String[] tmp_createrIds = params.getParameterAsArray("creatorId");
			if (tmp_createrIds != null && tmp_createrIds.length > 0) {
				for (String tmp_createId : tmp_createrIds) {
					if (!StringUtil.isBlank(tmp_createId)) {
						createArray.add(tmp_createId);
					}
				}
				createrIds = createArray.toArray(createrIds);
			}

			// tags参数处理
			List<String> tagArray = new ArrayList<String>();
			String[] tags = {};
			String[] tmp_tags = params.getParameterAsArray("tag");
			if (tmp_tags != null && tmp_tags.length > 0) {
				for (String tmp_tag : tmp_tags) {
					if (!StringUtil.isBlank(tmp_tag)) {
						tagArray.add(tmp_tag);
					}
				}
				tags = tagArray.toArray(tags);
			}

			String currDate = params.getParameterAsString("nowDate");

			if (StringUtil.isBlank(currDate)) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				currDate = format.format(new Date());
			}
			String dateRangeType = params.getParameterAsString("endDate");

			String orderName = params.getParameterAsString("orderName");
			String orderBy = params.getParameterAsString("orderBy");

			Integer page = 1;
			Integer lines = Integer.MAX_VALUE;

			WebUser user = getUser();

			DataPackage<Task> datas = ((TaskProcess) process).queryTasksByProject(projectId, taskName, status, levels,
					executerIds, createrIds, currDate, dateRangeType, tags, orderName, orderBy, page, lines,
					overdueStatus, user);

			this.response.setContentType("appliction/excel");
			this.response.setHeader("Content-Disposition",
					"attachment;filename=" + new String("任务列表.xls".getBytes(), "ISO-8859-1"));
			ServletOutputStream outputStream = this.response.getOutputStream();

			((TaskProcess) process).excelExportTask(outputStream, datas);

			if (outputStream != null) {
				outputStream.close();
			}
		} catch (Exception e) {
			// this.addFieldError("fileTypeError", "{*[任务导出失败]*}"); //错误提示信息
			addActionResult(false, e.getMessage(), null);
			e.printStackTrace();
		}
	}

	/**
	 * 以excel的形式批量导入任务
	 * 
	 * @return
	 */
	@RequestMapping(value = "/excelImportTask.action")
	public Map<String, Object> excelImportTask() {
		ParamsTable params = getParams();
		WebUser webUser = getUser();
		String projectId = params.getParameterAsString("projectId");
		String excelPath = params.getParameterAsString("excelPath");
		ProjectProcess projectProcess = new ProjectProcessBean();
		String aPath = Environment.getInstance().getRealPath("");
		File file = new File(aPath + excelPath);
		try {
			Project project = (Project) (projectProcess.doView(projectId));
			if (StringUtil.isBlank(projectId) || project == null) {
				throw new Exception("找不到需要导入任务的项目");
			}
			if (StringUtil.isBlank(excelPath) || !file.exists()) {
				throw new Exception("找不到导入任务的文件");
			} else {
				int num = ((TaskProcess) process).excelImportTask(file, project, webUser);
				return addActionResult(true, "成功导入" + num + "条任务。", "");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 判断是否存在SWF文件
	 * 
	 * @return
	 */
	@RequestMapping(value = "/hasSwfFile.action")
	public Map<String, Object> hasSwfFile() {
		ParamsTable params = getParams();
		String url = params.getParameterAsString("url");
		String id = params.getParameterAsString("id");
		String extName = params.getParameterAsString("extName");
		String aPath = Environment.getInstance().getRealPath("");
		try {
			StringBuffer swfPath = new StringBuffer();
			swfPath.append(url).append("/swf").append("/").append(id).append(".swf");

			File swffile = new File(aPath + File.separator + swfPath.toString());

			if (swffile.exists()) {
				return addActionResult(true, "", swfPath.toString());
			} else {
//				if (Config.previewEnabled() && Config.isReadableFile(extName)) {
					File file = new File(aPath + File.separator + url + File.separator + id + "." + extName);
					if (file.exists()) {
						// 创建SWF文件
						createSWF(extName, file.getAbsolutePath(), id);
						return addActionResult(false, "FileConversion", null);
					} else {
						return addActionResult(false, "FileMissing", null);
					}
//				} else {
//					return addActionResult(false, "PreviewUnabled", null);
//				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	private void createSWF(String fileType, String path, String uuid) throws Exception {
		try {
			if ("doc".equals(fileType) || "docx".equals(fileType) || "xls".equals(fileType) || "xlsx".equals(fileType)
					|| "pdf".equals(fileType) || "txt".equals(fileType) || "rtf".equals(fileType)
					|| "et".equals(fileType) || "ppt".equals(fileType) || "pptx".equals(fileType)
					|| "dps".equals(fileType) || "pot".equals(fileType) || "pps".equals(fileType)
					|| "wps".equals(fileType) || "html".equals(fileType) || "htm".equals(fileType)) {

				//生成转换文件任务
				uuid = StringUtils.substringBefore(path, ".");
				String rootPath = PropertyUtil.getPath();
				FileWriteUtil.writeKmConvertTask(rootPath,uuid,path);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}
}
