package com.teemlink.pm.task.action;

import cn.myapps.common.dao.PersistenceUtils;
import cn.myapps.common.util.DefaultProperty;
import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.DateUtil;
import cn.myapps.util.json.JsonUtil;
import com.teemlink.pm.task.model.Task;
import com.teemlink.pm.task.service.TaskProcessBean;
import com.teemlink.pm.util.Sequence;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.*;
import java.util.Map.Entry;

public class TaskUploadServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1507451476583038609L;

	// 通过doget请求处理
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		try {
			processRequest(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	// 通过dopost请求处理
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		try {
			processRequest(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void processRequest(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		// NDirProcess dirProcess = new NDirProcessBean();
		// String nFileId = null;
		// String nDirId = null;
		try {
			DiskFileItemFactory fac = new DiskFileItemFactory();
			ServletFileUpload upload = new ServletFileUpload(fac);
			upload.setHeaderEncoding("utf-8");
			List<FileItem> fileList = null;
			try {
				fileList = upload.parseRequest(request);
			} catch (FileUploadException ex) {
				return;
			}

			Iterator<FileItem> iter = fileList.iterator();
			String taskid = null;
			while (iter.hasNext()) {
				FileItem item = iter.next();
				if (item.isFormField()) {
					String fieldName = item.getFieldName();
					if (fieldName.equalsIgnoreCase("TaskId")) {
						taskid = item.getString("UTF-8");
					}
				}

			}

			String realPath = this.getServletConfig().getServletContext()
					.getRealPath("");// 服务器目录的绝对路径
			
			String uploadPath = DefaultProperty.getProperty(
					"myapps.pm.upload.path", "/uploads/pm/");
			
			String relativePath =  uploadPath + DateUtil.getCurDateStr("yyyyMM"); // 目录的相对路径
			String savePath = realPath + relativePath; // 存放此文件的绝对路径

			File f1 = new File(savePath);
			if (!f1.exists()) {
				f1.mkdirs();
			}

			Map<String, String> resultInfo = new HashMap<String, String>();
			Map<Object, Object> fileMap = new HashMap<Object, Object>();
			Map<Object, Object> fileMap2 = new HashMap<Object, Object>();

			Integer sortNo = 0;
			try{
				Map<String, Object> attachmentJson = null;
				String attachment = null;
				TaskProcessBean process = new TaskProcessBean();
				Task task = (Task) process.doView(taskid);
				attachment = task.getAttachment();
				attachmentJson = JsonUtil.toMap(attachment);
				for(Entry<String, Object> attach : attachmentJson.entrySet()) {
					Map<String, Object> detail = (Map<String, Object>)attach.getValue();
					if(detail.containsKey("sortNo")) {
						Integer sort = (Integer) detail.get("sortNo");
						sortNo = sortNo > sort ? sortNo + 1 : sort + 1;
					}
				}
			}catch(Exception e){
				
			}
			Iterator<FileItem> it = fileList.iterator();

			while (it.hasNext()) {
				FileItem item = it.next();
				if (!item.isFormField()) {
					String id = Sequence.getSequence();
					String extName = "";
					String name = item.getName();
					long size = item.getSize();
					resultInfo.put("id", id);
					resultInfo.put("name", name);
					resultInfo.put("size", String.valueOf(size));
					resultInfo.put("taskid", taskid);
					if (name == null || name.trim().equals("")) {
						continue;
					}
					// 扩展名格式：
					int index = name.lastIndexOf(".");
					resultInfo.put("title", name.substring(0, index));
					extName = name.substring(index);
					// 生成文件名：
					File saveFile = new File(savePath + File.separator + id
							+ extName);
					resultInfo.put("url", relativePath + File.separator + id
							+ extName);
					resultInfo.put("path", relativePath);
					fileMap.put("id", id);
					fileMap.put("name", name);
					fileMap.put("size", size);
					fileMap.put("url",relativePath);
					fileMap.put("sortNo", sortNo);
					fileMap2.put(id, fileMap);
					
					boolean isCompress = false;
					try {
						item.write(saveFile); // 文件上传到服务器
						//压缩图片
						isCompress = imgCompress(saveFile,size,extName,savePath);
						//创建SWF文件
						 createSWF(extName.substring(1, extName.length()), savePath+ "/" + id + extName, id);
					} catch (Exception e) {
						e.printStackTrace();
					}
					fileMap.put("isCompress", isCompress);
					resultInfo.put("isCompress", String.valueOf(isCompress));
				}
			}
			String attachjson = JsonUtil.toJson(fileMap2);
			//
			try {
				TaskProcessBean process = new TaskProcessBean();
				if (process.doView(taskid) != null) {
					process.addAttachment(taskid, attachjson);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			PrintWriter writer = encodehead(request, response);
			String result = JsonUtil.toJson(resultInfo);
			writer.print(result);
			writer.flush();
			writer.close();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				PersistenceUtils.closeSessionAndConnection();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	private void  createSWF(String fileType,String path ,String uuid) throws Exception{
		try {
			if ("doc".equals(fileType) || "docx".equals(fileType)
					|| "xls".equals(fileType) || "xlsx".equals(fileType)
					|| "pdf".equals(fileType) || "txt".equals(fileType)
					|| "rtf".equals(fileType) || "et".equals(fileType)
					|| "ppt".equals(fileType) || "pptx".equals(fileType)
					|| "dps".equals(fileType) || "pot".equals(fileType)
					|| "pps".equals(fileType) || "wps".equals(fileType)
					|| "html".equals(fileType) || "htm".equals(fileType)) {

				//生成转换文件任务
				uuid = StringUtils.substringBefore(path, ".");
				String rootPath = PropertyUtil.getPath();
				FileWriteUtil.writeKmConvertTask(rootPath,uuid,path);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	/**
	 * 图片压缩
	 * @param fileMap 
	 * @return
	 */
	public boolean imgCompress(File file, long size,String extName,String path){
		if(size >= 100*1024){  //超出100K的图片才压缩
			if(isCompressFormat(extName)){
				try {
					if(!StringUtil.isBlank(file.getName())){
						 scaleImageWithParams(file,path,size,"jpg");
						 return true;
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return false;
	}
	
	private boolean isCompressFormat(String extName){
		if(".gif".equalsIgnoreCase(extName) || 
		   ".bmp".equalsIgnoreCase(extName) || 
		   ".jpg".equalsIgnoreCase(extName) || 
		   ".png".equalsIgnoreCase(extName) || 
		   ".jpeg".equalsIgnoreCase(extName)){
			return true;
		}else{
			return false;
		}
	}
    
    /*** 
     * 将图片缩放到指定的高度或者宽度 
     * @param imgUri 图片源地址 
     * @param destinationPath 压缩完图片的地址 
     * @param width 缩放后的宽度 
     * @param height 缩放后的高度 
     * @param auto 是否自动保持图片的原高宽比例 
     * @param format 图图片格式 例如 jpg 
     * @throws Exception 
     */ 
    private void scaleImageWithParams(File file,String contextPath,long size,String format) throws Exception { 
       
      try { 
      BufferedImage bufferedImage = ImageIO.read(file);
      int width = bufferedImage.getWidth();
      int height = bufferedImage.getHeight();
     
      ArrayList<Integer> paramsArrayList = getAutoWidthAndHeightBySize(bufferedImage,size); 
      width = paramsArrayList.get(0); 
      height = paramsArrayList.get(1); 
      
      Image image = bufferedImage.getScaledInstance(width, height, Image.SCALE_FAST); 
      BufferedImage outputImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB); 
      Graphics graphics = outputImage.getGraphics(); 
      graphics.drawImage(image, 0, 0, null); 
      graphics.dispose(); 
      
      String fileName = "Compress_"+file.getName();
      ImageIO.write(outputImage, format, new File(contextPath+File.separator+fileName)); 
      } catch (Exception e) { 
    	  throw e;
      } 
    } 
   
    /** 
     * 将double类型的数据转换为int，四舍五入原则 
     * 
     * @param sourceDouble 
     * @return 
     */ 
    private  int parseDoubleToInt(double sourceDouble) { 
      int result = 0; 
      result = (int) sourceDouble; 
      return result; 
    } 
     
    /*** 
     * 
     * @param bufferedImage 根据图片对象大小获取对应的缩小比例
     * @return 一个集合，第一个元素为宽度，第二个元素为高度 
     */ 
    private  ArrayList<Integer> getAutoWidthAndHeightBySize(BufferedImage bufferedImage,long size){ 
      ArrayList<Integer> arrayList = new ArrayList<Integer>(); 
      
      Double d = (double) bufferedImage.getWidth(); 
      Double e = (double) bufferedImage.getWidth();
      
      if(size > 5 * 1024 * 1024){ //5MB
    	  d = d * 0.5;
    	  e = d * 0.5;
      }else if(size > 3 * 1024 *1024){ //3MB
    	  d = d * 0.6;
    	  e = d * 0.6;
      }else if(size > 1024 *1024){ //1MB
    	  d = d * 0.7;
    	  e = d * 0.7;
      }else if(size > 512 * 1024){  //512KB
    	  d = d * 0.8;
    	  e = d * 0.8;
      }
      
      int width = bufferedImage.getWidth(); 
      int height = bufferedImage.getHeight(); 
      
      double scale_w =getDot2Decimal(d,width); 
      double scale_h = getDot2Decimal(e,height); 
      if (scale_w<scale_h) { 
        arrayList.add(parseDoubleToInt(scale_w*width)); 
        arrayList.add(parseDoubleToInt(scale_w*height)); 
      } 
      else { 
        arrayList.add(parseDoubleToInt(scale_h*width)); 
        arrayList.add(parseDoubleToInt(scale_h*height)); 
      } 
      return arrayList; 
    } 
     
    /*** 
     * 返回两个数a/b的小数点后三位的表示 
     * @param d 
     * @param b 
     * @return 
     */ 
    public  double getDot2Decimal(double d,int b){ 
       
      BigDecimal bigDecimal_1 = new BigDecimal(d); 
      BigDecimal bigDecimal_2 = new BigDecimal(b); 
      BigDecimal bigDecimal_result = bigDecimal_1.divide(bigDecimal_2,new MathContext(4)); 
      Double double1 = new Double(bigDecimal_result.toString()); 
      return double1; 
    } 

	/**
	 * Ajax辅助方法 获取 PrintWriter
	 * 
	 * @return
	 * @throws IOException
	 * @throws IOException
	 *             request.setCharacterEncoding("utf-8");
	 *             response.setContentType("text/html; charset=utf-8");
	 */
	private PrintWriter encodehead(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		request.setCharacterEncoding("utf-8");
		response.setContentType("text/html; charset=utf-8");
		return response.getWriter();
	}

}
