package com.teemlink.pm.tag.dao;

import java.util.Collection;

import com.teemlink.pm.base.dao.BaseDAO;
import com.teemlink.pm.tag.model.Tag;

import cn.myapps.base.web.WebUser;

public interface TagDAO extends BaseDAO {
	/**
	 * 根据项目Id查询项目所属的标签
	 * @param projectId
	 * 			项目 Id
	 * @return
	 * @throws Exception
	 */
	public Collection<Tag> queryTagsByProjectId(String projectId) throws Exception;
	
	/**
	 * 查询的所在的项目的所有标签
	 * @param user
	 * 			前台用户
	 * @return
	 * @throws Exception
	 */
	public Collection<Tag> queryTags4MyProject(WebUser user) throws Exception;
}
