package com.teemlink.pm.tag.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.teemlink.pm.base.dao.AbstractBaseDAO;
import com.teemlink.pm.tag.model.Tag;
import com.teemlink.pm.util.ConnectionManager;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.ValueObject;

public abstract class AbstractTagDAO extends AbstractBaseDAO {

	private static final Logger log = LoggerFactory.getLogger(AbstractTagDAO.class);

	public AbstractTagDAO(Connection conn) throws Exception {
		super(conn);
		this.tableName = "PM_TAG";
	}

	public ValueObject create(ValueObject vo) throws Exception {
		Tag tag = (Tag) vo;

		PreparedStatement stmt = null;

		String sql = "INSERT INTO " + getFullTableName(tableName)
				+ " (ID,NAME,DOMAIN_ID,PROJECT_ID) values (?,?,?,?)";

		log.debug("{}", sql);
		try {
			stmt = connection.prepareStatement(sql);
			stmt.setString(1, tag.getId());
			stmt.setString(2, tag.getName());
			stmt.setString(3, tag.getDomainid());
			stmt.setString(4, tag.getProjectId());
			stmt.execute();
		} catch (Exception e) {
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

		return vo;

	}

	public ValueObject find(String id) throws Exception {
		PreparedStatement stmt = null;

		String sql = "SELECT * FROM " + getFullTableName(tableName)
				+ " WHERE ID=?";

		log.debug("{}", sql);
		try {
			stmt = connection.prepareStatement(sql);
			stmt.setString(1, id);

			ResultSet rs = stmt.executeQuery();
			Tag tag = null;
			if (rs.next()) {
				tag = new Tag();
				setProperties(tag, rs);
			}
			rs.close();
			return tag;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}
	}

	public void remove(String pk) throws Exception {
		PreparedStatement stmt = null;

		String sql = "DELETE FROM " + getFullTableName(tableName)
				+ " WHERE ID=?";

		try {
			stmt = connection.prepareStatement(sql);
			stmt.setString(1, pk);
			log.debug("{}", sql);
			stmt.execute();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}

	}

	public ValueObject update(ValueObject vo) throws Exception {
		Tag tag = (Tag) vo;
		PreparedStatement stmt = null;

		String sql = "UPDATE " + getFullTableName(tableName)
				+ " SET NAME=?,DOMAIN_ID=?,PROJECT_ID=? WHERE ID=?";

		log.debug("{}", sql);
		try {
			stmt = connection.prepareStatement(sql);

			stmt.setString(1, tag.getName());
			stmt.setString(2, tag.getDomainid());
			stmt.setString(3, tag.getProjectId());
			stmt.setString(4, tag.getId());
			stmt.execute();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}
		return vo;
	}

	public Collection<?> simpleQuery(ParamsTable params, WebUser user)
			throws Exception {
		Collection<Tag> rtn = new ArrayList<Tag>();

		PreparedStatement stmt = null;

		String sql = "SELECT * FROM " + getFullTableName(tableName)
				+ " WHERE DOMAIN_ID=? AND PROJECT_ID=? ORDER BY ID DESC";

		log.debug("{}", sql);
		try {
			stmt = connection.prepareStatement(sql);
			stmt.setString(1, user.getDomainid());
			stmt.setString(2, params.getParameterAsString("projectId"));
			ResultSet rs = stmt.executeQuery();
			Tag tag = null;
			while (rs.next()) {
				tag = new Tag();
				setProperties(tag, rs);
				rtn.add(tag);
			}
			rs.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}
		return rtn;

	}

	void setProperties(Tag tag, ResultSet rs) throws Exception {
		try {
			tag.setId(rs.getString("ID"));
			tag.setName(rs.getString("NAME"));
			tag.setDomainid(rs.getString("DOMAIN_ID"));
			tag.setProjectId(rs.getString("PROJECT_ID"));
		} catch (SQLException e) {
			throw e;
		}

	}
	
	public Collection<Tag> queryTagsByProjectId(String projectId) throws Exception{
		Collection<Tag> rtn = new ArrayList<Tag>();

		PreparedStatement stmt = null;

		String sql = "SELECT * FROM " + getFullTableName(tableName)
				+ " WHERE PROJECT_ID=? ORDER BY ID DESC";

		log.debug("{}", sql);
		try {
			stmt = connection.prepareStatement(sql);
			stmt.setString(1, projectId);
			ResultSet rs = stmt.executeQuery();
			Tag tag = null;
			while (rs.next()) {
				tag = new Tag();
				setProperties(tag, rs);
				rtn.add(tag);
			}
			rs.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}
		return rtn;
	}
	
	public Collection<Tag> queryTags4MyProject(WebUser user) throws Exception{
		Collection<Tag> rtn = new ArrayList<Tag>();

		PreparedStatement stmt = null;

		StringBuffer sql = new StringBuffer();

		sql.append("SELECT t.* FROM ").append(getFullTableName(tableName))
				.append(" t");
		sql.append(" WHERE t.PROJECT_ID IN (SELECT p.PROJECT_ID FROM ")
				.append(getFullTableName("PM_PROJECT_MEMBER_SET")).append(" p WHERE p.USER_ID=?) ORDER BY ID DESC");

		log.debug("{}", sql.toString());
		try {
			stmt = connection.prepareStatement(sql.toString());
			stmt.setString(1, user.getId());
			ResultSet rs = stmt.executeQuery();
			Tag tag = null;
			while (rs.next()) {
				tag = new Tag();
				setProperties(tag, rs);
				rtn.add(tag);
			}
			rs.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			ConnectionManager.closeStatement(stmt);
		}
		return rtn;
	}
}
