package com.teemlink.pm.tag.controller;

import java.util.Collection;
import java.util.Map;

import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.teemlink.pm.base.controller.BaseController;
import com.teemlink.pm.tag.model.Tag;
import com.teemlink.pm.tag.service.TagProcess;
import com.teemlink.pm.tag.service.TagProcessBean;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.exception.OBPMValidateException;

@Controller(value="TagAction")
@RequestMapping(value="/pm/tag")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class TagController extends BaseController<Tag>{
	

	public TagController() {
		super();
		content = new Tag();
		process = new TagProcessBean();
	}
	
	@RequestMapping(value="/create.action")
	public Map<String, Object> doCreate(){
		try {
			WebUser user = getUser();
			Tag tag = (Tag) getContent();
			tag.setDomainid(user.getDomainid());
			
			tag = (Tag) process.doCreate(tag);
			return addActionResult(true, "添加成功", tag);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/delete.action")
	public Map<String, Object> doDelete(){
		try {
			process.doRemove(get_selects());
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/query.action")
	public Map<String, Object> doQuery() {
		try {
			
			Collection<Tag> list = ((TagProcess)process).doSimpleQuery(getParams(), getUser());
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/queryTags4MyProject.action")
	public Map<String, Object> queryTags4MyProject() {
		try {
			Collection<Tag> list = ((TagProcess)process).queryTags4MyProject(getUser());
			return addActionResult(true, "", list);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
}
