package com.teemlink.pm.project.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.teemlink.pm.base.dao.BaseDAO;
import com.teemlink.pm.base.dao.DaoManager;
import com.teemlink.pm.base.service.AbstractBaseProcessBean;
import com.teemlink.pm.project.dao.ProjectDAO;
import com.teemlink.pm.project.model.Member;
import com.teemlink.pm.project.model.Project;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.sequence.Sequence;


public class ProjectProcessBean extends AbstractBaseProcessBean<Project>
		implements ProjectProcess {

	@Override
	public BaseDAO getDAO() throws Exception {
		return DaoManager.getProjectDAO(getConnection());
	}

	public long countByName(String name) throws Exception {
		return ((ProjectDAO)getDAO()).countByName(name);
	}

	public void updateName(String name, String pk) throws Exception {
		Map<String,Object> items = new HashMap<String, Object>();
		items.put("NAME", name);
		((ProjectDAO)getDAO()).update(items, pk);
	}

	public Collection<Member> getMembersByProject(String projectId,String memberGroup)
			throws Exception {
		return ((ProjectDAO)getDAO()).queryMembersByProject(projectId,memberGroup);
	}

	public void addMembers(Collection<Member> addMember, String projectId)
			throws Exception {
		try {
			Collection<Member> members = new ArrayList<Member>();
			Collection<Member> allMember = getMembersByProject(projectId, "");
			
			// 避免在同一个项目里添加角色相同的成员
			for (Member add : addMember) {
				boolean find = false;
				for (Member all : allMember) {
					if (add.getUserId().equals(all.getUserId()) && add.getMemberType() == all.getMemberType()) {
						find = true;
						break;
					}
				}
				if (!find)
					members.add(add);
			}
			
			beginTransaction();
			((ProjectDAO)getDAO()).addMembers(members, projectId);
			commitTransaction();
		} catch (Exception e) {
			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
	}

	public void deleteMember(String userId, String projectId,int memberType) throws Exception {
		try {
			beginTransaction();
			((ProjectDAO)getDAO()).deleteMember(userId, projectId,memberType);
			commitTransaction();
		} catch (Exception e) {
			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
		
	}

	public void setProjectManager(String userId, String projectId)
			throws Exception {
		try {
			beginTransaction();
			((ProjectDAO)getDAO()).setProjectManager(userId, projectId);
			commitTransaction();
		} catch (Exception e) {
			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
		
	}
	/**
	 * 更新任务总数
	 * @param projectId
	 * @throws Exception
	 */
	public void updateTasksTotal(String projectId) throws Exception {
		try {
			beginTransaction();
			((ProjectDAO)getDAO()).updateTasksTotal(projectId);
			commitTransaction();
		} catch (Exception e) {
			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
	}

	public Project doCreate(Project project, WebUser user) throws Exception {
		try {
			if(StringUtil.isBlank(project.getId())){
				project.setId(Sequence.getSequence());
			}
			Collection<Member> members = new ArrayList<Member>();
			Member member = new Member();
			member.setMemberType(Member.MEMBER_MANAGER);
			member.setUserId(user.getId());
			member.setUserName(user.getName());
			members.add(member);
			
			beginTransaction();
			((ProjectDAO)getDAO()).create(project);
			((ProjectDAO)getDAO()).addMembers(members, project.getId());
			commitTransaction();
		} catch (Exception e) {
			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
		
		return project;
	}

	public Collection<Project> doQueryMyProject(String name, Integer status, WebUser user)
			throws Exception {
		return ((ProjectDAO)getDAO()).queryMyProject(name, status, user);
	}
	
	public Collection<Project> queryMyProject4Task(WebUser user)
			throws Exception {
		return ((ProjectDAO)getDAO()).queryMyProject4Task(user);
	}

	@Override
	public boolean closeProject(String projectId) throws Exception {
		try{
			beginTransaction();
			Project project = (Project) getDAO().find(projectId);
			project.setClosed(true);
			getDAO().update(project);
			commitTransaction();
		}catch(Exception e){
			rollbackTransaction();
			return false;
		}
		return true;
	}

	@Override
	public boolean openProject(String projectId) throws Exception {
		try{
			beginTransaction();
			Project project = (Project) getDAO().find(projectId);
			project.setClosed(false);
			getDAO().update(project);
			commitTransaction();
		}catch(Exception e){
			rollbackTransaction();
			return false;
		}
		return true;
	}

	@Override
	public Member queryMemberByName4Project(String projectId, String name) throws Exception{
		return ((ProjectDAO)getDAO()).queryMemberByName4Project(projectId, name);
	}
	
	@Override
	public Member getMerberByWebUser4Project(String projectId, WebUser user) throws Exception{
		return ((ProjectDAO)getDAO()).getMerberByWebUser4Project(projectId, user);
	}

}
