package com.teemlink.pm.project.dao;

import java.util.Collection;

import com.teemlink.pm.base.dao.BaseDAO;
import com.teemlink.pm.project.model.Member;
import com.teemlink.pm.project.model.Project;

import cn.myapps.base.web.WebUser;

public interface ProjectDAO extends BaseDAO {
	
	/**
	 * 根据项目名称查询项目总数
	 * @param name
	 * 		项目名称
	 * @return
	 * 		项目总数
	 * @throws Exception
	 */
	public long countByName(String name) throws Exception;
	
	/**
	 * 查询项目的成员集合
	 * @param projectId
	 * 		项目主键
	 * @param memberGroup
	 * 		成员类型
	 * @return
	 * @throws Exception
	 */
	public Collection<Member> queryMembersByProject(String projectId,String memberGroup) throws Exception;
	
	/**
	 * 添加项目成员
	 * @param members
	 * 		成员集合
	 * @param projectId
	 * 		项目主键
	 * @throws Exception
	 */
	public void addMembers(Collection<Member> members,String projectId) throws Exception;
	
	/**
	 * 删除项目成员
	 * @param userId
	 * 		用户主键
	 * @param projectId
	 * 		项目主键
	 * @param memberType
	 *      成员类型
	 * @throws Exception
	 */
	public void deleteMember(String userId,String projectId,int memberType) throws Exception;
	
	/**
	 * 设置用户为项目经理
	 * @param userId
	 * 		用户主键
	 * @param projectId
	 * 		项目主键
	 * @throws Exception
	 */
	public void setProjectManager(String userId,String projectId) throws Exception;
	
	/**
	 * 更新任务总数
	 * @param projectId
	 * @throws Exception
	 */
	public void updateTasksTotal(String projectId) throws Exception;	
	
	/**
	 * 查询我的项目
	 * @param name
	 * 		项目名称
	 * @param status
	 * 		项目状态，1为关闭，0为打开，null为全部。
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Collection<Project> queryMyProject(String name, Integer status, WebUser user) throws Exception;
	
	/**
	 * 查询我的项目,过滤只是关注人的项目
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Collection<Project> queryMyProject4Task(WebUser user) throws Exception;
	
	/**
	 * 根据名字查询某项目中的成员
	 * @param projectId
	 * 		项目ID
	 * @param name
	 * 		成员名字
	 * @return
	 * 		若查询到项目成员集合返回第一个成员Member对象,失败返回null.
	 * @throws Exception
	 */
	public Member queryMemberByName4Project(String projectId, String name) throws Exception;
	
	/**
	 * 根据用户查询某项目中的成员
	 * @param projectId
	 * 		项目ID
	 * @param WebUser
	 * 		用户
	 * @return
	 * 		若查询到项目成员集合返回第一个成员Member对象,失败返回null.
	 * @throws Exception
	 */
	public Member getMerberByWebUser4Project(String projectId, WebUser user) throws Exception;

}
