package com.teemlink.pm.project.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.teemlink.pm.base.controller.BaseController;
import com.teemlink.pm.project.model.Member;
import com.teemlink.pm.project.model.Project;
import com.teemlink.pm.project.service.ProjectProcess;
import com.teemlink.pm.project.service.ProjectProcessBean;
import com.teemlink.pm.report.util.HtmlReport2;
import com.teemlink.pm.util.json.JsonUtil;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.StringUtil;

@Controller(value="ProjectAction")
@RequestMapping(value="/pm/project")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ProjectController extends BaseController<Project>{
	
	@Autowired
	private HttpServletRequest request;

	public ProjectController() {
		super();
		content = new Project();
		process = new ProjectProcessBean();
	}
	
	/**
	 * 新建项目
	 * @return
	 */
	@RequestMapping(value="/create.action")
	public Map<String, Object> doCreate(){
		WebUser user = getUser();
		
		Project project = (Project) getContent();
		project.setCreator(user.getName());
		
		project.setCreatorId(user.getId());
		project.setDomainid(user.getDomainid());
		project.setManager(user.getName());
		project.setManagerId(user.getId());
		project.setCreateDate(new Date());
		try {
			long count = ((ProjectProcess)process).countByName(project.getName());
			if(count>0){
				throw new OBPMValidateException("项目名已存在");
			}
			project = (Project) ((ProjectProcess)process).doCreate(project,user);
			return addActionResult(true, "添加成功", project);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/view.action")
	public Map<String, Object> doView(){
		try {
			ParamsTable params  = getParams();
			String id = params.getParameterAsString("id");
			Project project = (Project)process.doView(id);
			return addActionResult(true, null, project);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/save.action")
	public Map<String, Object> doSave(){
		Project project = (Project) getContent();
		try {
			Project old = (Project)process.doView(project.getId());
			if(old !=null && !old.getName().equals(project.getName())){
				long count = ((ProjectProcess)process).countByName(project.getName());
				if(count>0){
					throw new OBPMValidateException("项目名已存在");
				}
			}
			((ProjectProcess)process).updateName(project.getName(), project.getId());
			return addActionResult(true, "保存成功", null);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/queryMyProject.action")
	public Map<String, Object> doQueryMyProject(){
		ParamsTable params  = getParams();
		WebUser user = getUser();
		String name = params.getParameterAsString("name");
		Integer status = null;
		if("CLOSE".equalsIgnoreCase(params.getParameterAsString("status"))){
			status = 1;
		} else if("OPEN".equalsIgnoreCase(params.getParameterAsString("status"))){
			status = 0;
		}
		try {
			Collection<Project> datas = ((ProjectProcess)process).doQueryMyProject(name, status, user);
			return addActionResult(true, null, datas);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/dynamicReport/html.action")
	public String dynamicReportGenerateHtml(@RequestParam String projectId){
		//根据项目id执行生成html
		String saveHtmlPath=request.getRealPath("/");
		saveHtmlPath+="/pm/report.html";
		new HtmlReport2(saveHtmlPath, projectId,getUser());
		return "success";
	}
	
	@RequestMapping(value="/queryMyProject4Task.action")
	public Map<String, Object> queryMyProject4Task(){
		WebUser user = getUser();
		try {
			Collection<Project> datas = ((ProjectProcess)process).queryMyProject4Task(user);
			return addActionResult(true, null, datas);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/query.action")
	public Map<String, Object> doQuery(){
		ParamsTable params  = getParams();
		WebUser user = getUser();
		try {
			Collection<Project> datas = ((ProjectProcess)process).doSimpleQuery(params, user);
			return addActionResult(true, null, datas);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	@RequestMapping(value="/delete.action")
	public Map<String, Object> doRemove(){
		
		try {
			String[] pks = get_selects();
			process.doRemove(pks);
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
		
	}
	
	/**
	 * 关闭项目，需传参数projectId
	 * @return
	 */
	@RequestMapping(value="/closeProject.action")
	public Map<String, Object> closeProject(){

		ParamsTable params  = getParams();
		
		String projectId = params.getParameterAsString("projectId");
		try {
			Project project = (Project)process.doView(projectId);
			project.setClosed(Project.PROJECT_CLOSE);
			((ProjectProcess) process).doUpdate(project);
			
			return addActionResult(true, "设置成功", null);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
		
	}
	
	/**
	 * 打开项目，需传参数projectId
	 * @return
	 */
	@RequestMapping(value="/openProject.action")
	public Map<String, Object> openProject(){

		ParamsTable params  = getParams();
		
		String projectId = params.getParameterAsString("projectId");
		try {
			Project project = (Project)process.doView(projectId);
			project.setClosed(Project.PROJECT_OPEN);
			((ProjectProcess) process).doUpdate(project);
			
			return addActionResult(true, "设置成功", null);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
		
	}
	
	/**
	 * 添加项目成员
	 * @return
	 */
	@RequestMapping(value="/addMembers.action")
	public Map<String, Object> doAddMembers(){
		
		try {
			Collection<Member> members = new ArrayList<Member>();
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String _members = params.getParameterAsString("members");
			if(!StringUtil.isBlank(_members)){
				members.addAll((Collection<? extends Member>) JsonUtil.toCollection(_members, Member.class));
			}
			((ProjectProcess) process).addMembers(members, id);
			return addActionResult(true, "添加成功", process.doView(id));
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 * 移除项目成员
	 * @return
	 */
	@RequestMapping(value="/removeMember.action")
	public Map<String, Object> doRemoveMember(){
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String userId = params.getParameterAsString("userId");
			int memberType = params.getParameterAsInteger("memberType");
			((ProjectProcess) process).deleteMember(userId,id,memberType);
			return addActionResult(true, "删除成功", process.doView(id));
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
		
	}
	
	/**
	 * 设置项目经理
	 * @return
	 */
	@RequestMapping(value="/setProjectManager.action")
	public Map<String, Object> doSetProjectManager(){
		
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String userId = params.getParameterAsString("userId");
			
			((ProjectProcess) process).setProjectManager(userId, id);
			return addActionResult(true, "设置成功", process.doView(id));
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 *  通过ProjectId获取项目下的所有成员
	 * @return
	 */
	@RequestMapping(value="/getMembersByProjectId.action")
	public Map<String, Object> doGetMembersByProject(){
		try {
			ParamsTable params  = getParams();
			String projectId= params.getParameterAsString("projectId");		
			String memberGroup = params.getParameterAsString("memberGroup");	
			
			Collection<Member> membersList = ((ProjectProcess) process).getMembersByProject(projectId,memberGroup);
			return addActionResult(true, "获取成功",membersList );
			
			
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	
	/**
	 *  通过ProjectId获取项目,修改是否微信通知
	 * @return
	 */
	@RequestMapping(value="/doUpdateNotification.action")
	public Map<String, Object> doUpdateNotification(){
		try {
			ParamsTable params = getParams();
			String projectId = params.getParameterAsString("projectId");
			int notification ;
			if(!StringUtil.isBlank(params.getParameterAsString("notification"))){
				notification = params.getParameterAsInteger("notification");
			}else{
				notification = 0;
			}
			Project project = (Project)process.doView(projectId);
			
			if(notification == 1){
				project.setNotification(true);
			}else if(notification == 0){
				project.setNotification(false);
			}
			
			((ProjectProcess) process).doUpdate(project);
			
			return addActionResult(true, "设置成功", null);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}

	@RequestMapping(value="/queryMemberByWebUser4Project.action")
	public Map<String, Object> queryMemberByWebUser4Project(){
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			String projectId = params.getParameterAsString("projectId");
			if(StringUtil.isBlank(projectId)){
				throw new Exception("查询出错");
			}
			Member member = ((ProjectProcess) process).getMerberByWebUser4Project(projectId, user);
			return addActionResult(true, "", member);
		} catch (Exception e) {
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
			return addActionResult(false, e.getMessage(), null);
		}
	}
}
