package com.teemlink.pm.base.schema.dao;

import java.sql.Connection;

import cn.myapps.common.model.table.Table;
import cn.myapps.common.util.DbUtil;
import cn.myapps.designtime.table.ddlutil.postgresql.PostgreSQLTableDefinition;
import cn.myapps.util.DbTypeUtil;

public class PostgreSQLSchemaDAO extends AbstractSchemaDAO {

	public PostgreSQLSchemaDAO(Connection conn) throws Exception {
		super(conn);
		this.dbType = "POSTGRESQL: ";
		this.schema = DbUtil.getSchema(conn, DbUtil.DBTYPE_POSTGRESQL);
		this.definition = new PostgreSQLTableDefinition(conn);
	}

	protected Table getDBTable(String tableName) {
		return (Table) DbUtil.getTable(tableName, DbUtil.DBTYPE_POSTGRESQL, this.connection);
	}

}
