package com.teemlink.pm.base.schema;

import java.sql.Connection;

import com.teemlink.pm.base.schema.dao.*;
import com.teemlink.pm.util.ConnectionManager;


/**
 * PM数据库表结构维护类
 * 
 * <p>自动维护PM数据库表结构的初始化和更新工作</p>
 * 
 * @author Happy
 *
 */
public class SchemaHelper {
	
    private static SchemaHelper instance;
    
    private boolean initialized;
    
	private AbstractSchemaDAO schemaDAO;
	
	private Connection conn;
	
    private SchemaHelper() {
        initialized = false;
    }
	
    public static SchemaHelper getInstance() {
        if (instance == null) {
            synchronized (SchemaHelper.class) {
                if (instance == null) {
                    instance = new SchemaHelper();
                }
            }
        }
        return instance;
    }
	
	public void init() throws Exception {
		try {
		    if(initialized) return;
			conn = ConnectionManager.getConnection();
			initSchema();
			initBaseData();
			initIndex();
			initialized = true;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}finally{
			if(conn !=null && !conn.isClosed()){
				conn.close();
			}
		}
	}

	public AbstractSchemaDAO getSchemaDAO() {
		if(schemaDAO ==null){
			try {
				String dbType = ConnectionManager.dbType.toUpperCase();
				if("MSSQL".equals(dbType)){  
					schemaDAO = new MssqlSchemaDAO(getConn());
				}else if("ORACLE".equals(dbType)){
					schemaDAO = new OraclelSchemaDAO(getConn());
				}else if("DB2".equals(dbType)){
					schemaDAO = new DB2SchemaDAO(getConn());
				}else if("MYSQL".equals(dbType)){
					schemaDAO = new MysqlSchemaDAO(getConn());
				}else if("POSTGRESQL".equals(dbType)){
					schemaDAO = new PostgreSQLSchemaDAO(getConn());
				}else if("DM".equals(dbType)){
					schemaDAO = new DmSQLSchemaDAO(getConn());
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		return schemaDAO;
	}

	public Connection getConn() {
		if(conn ==null){
			try {
				conn = ConnectionManager.getConnection();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		return conn;
	}
	
	public void initSchema() throws Exception {
		
		try {
			getSchemaDAO().initTables();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
		
	}

	private void initIndex() throws Exception {
		try {
			getSchemaDAO().initIndex();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	
	public void initBaseData() throws Exception {
		try {
		} catch (Exception e) {
			throw e;
		}
	}
	
}
