package com.teemlink.pm.base.dao;

import java.sql.Connection;

import com.teemlink.pm.activity.dao.*;
import com.teemlink.pm.project.dao.*;
import com.teemlink.pm.tag.dao.*;
import com.teemlink.pm.task.dao.*;
import com.teemlink.pm.util.ConnectionManager;

public class DaoManager {
	

	public static BaseDAO getProjectDAO(Connection conn) throws Exception{
		String dbType = ConnectionManager.dbType;
		if("MSSQL".equals(dbType)){  
			return new MsSqlProjectDAO(conn);
		}else if("ORACLE".equals(dbType)){
			return new OracleProjectDAO(conn);
		}else if("DB2".equals(dbType)){
			return new DB2ProjectDAO(conn);
		}else if("MYSQL".equals(dbType)){
			return new MySqlProjectDAO(conn);
		}else if("POSTGRESQL".equals(dbType)){
			return new PostgreSQLProjectDAO(conn);
		}else if("DM".equals(dbType)){
			return new DmSQLProjectDAO(conn);
		}
		
		return null;
	}
	
	public static BaseDAO getTaskDAO(Connection conn) throws Exception{
		String dbType = ConnectionManager.dbType;
		if("MSSQL".equals(dbType)){  
			return new MsSqlTaskDAO(conn);
		}else if("ORACLE".equals(dbType)){
			return new OracleTaskDAO(conn);
		}else if("DB2".equals(dbType)){
			return new DB2TaskDAO(conn);
		}else if("MYSQL".equals(dbType)){
			return new MySqlTaskDAO(conn);
		}else if("POSTGRESQL".equals(dbType)){
			return new PostgreSQLTaskDAO(conn);
		}else if("DM".equals(dbType)){
			return new DmSQLTaskDAO(conn);
		}
		
		return null;
	}
	
	public static BaseDAO getTagDAO(Connection conn) throws Exception{
		String dbType = ConnectionManager.dbType;
		if("MSSQL".equals(dbType)){  
			return new MsSqlTagDAO(conn);
		}else if("ORACLE".equals(dbType)){
			return new OracleTagDAO(conn);
		}else if("DB2".equals(dbType)){
			return new DB2TagDAO(conn);
		}else if("MYSQL".equals(dbType)){
			return new MySqlTagDAO(conn);
		}else if("POSTGRESQL".equals(dbType)){
			return new PostgreSQLTagDAO(conn);
		}else if("DM".equals(dbType)){
			return new DmSQLTagDAO(conn);
		}
		
		return null;
	}
	
	public static BaseDAO getActivityDAO(Connection conn) throws Exception{
		String dbType = ConnectionManager.dbType;
		if("MSSQL".equals(dbType)){  
			return new MsSqlActivityDAO(conn);
		}else if("ORACLE".equals(dbType)){
			return new OracleActivityDAO(conn);
		}else if("DB2".equals(dbType)){
			return new DB2ActivityDAO(conn);
		}else if("MYSQL".equals(dbType)){
			return new MySqlActivityDAO(conn);
		}else if("POSTGRESQL".equals(dbType)){
			return new PostgreSQLActivityDAO(conn);
		}else if("DM".equals(dbType)){
			return new DmSQLActivityDAO(conn);
		}
		
		return null;
	}

	
}
