package com.teemlink.pm.base.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.ValueObject;
import cn.myapps.constans.Web;
import com.teemlink.pm.base.service.BaseProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;

@RestController(value="PMBaseAction")
public class BaseController<E> {

	protected static final String ACTION_RESULT_KEY = "status";
	protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
	protected static final int ACTION_RESULT_VALUE_FAULT = 0;
	
	protected static final String ACTION_MESSAGE_KEY = "message";
	protected static final String ACTION_DATA_KEY = "data";
	
	
	
	
	//将会被Struts2序列化为JSON字符串的对象,用来作为控制层返回结果的容器
	protected Map<String, Object> dataMap = new HashMap<String, Object>();

	protected String[] _selects = null;
	
	protected ParamsTable params;
	
	protected ValueObject content = null;
	
	protected BaseProcess<E> process = null;
	
	protected DataPackage<E> datas = null;
	
	@Autowired  
	protected HttpServletRequest request;
	
	@Autowired
	protected HttpSession session; 
	
	public String[] get_selects() {
		return _selects;
	}
	public void set_selects(String[] selects) {
		_selects = selects;
	}
	public ParamsTable getParams() {
		if (params == null) {
			params = ParamsTable.convertHTTP(this.request);

			params.setSessionid(this.request.getSession().getId());

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}

		return params;
	}
	
	public ParamsTable getParams(HttpServletRequest request) {
		if (params == null) {
			params = ParamsTable.convertHTTP(this.request);

			params.setSessionid(this.request.getSession().getId());

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}

		return params;
	}
	public ValueObject getContent() {
		return content;
	}
	public void setContent(ValueObject content) {
		this.content = content;
	}
	public DataPackage<E> getDatas() {
		return datas;
	}
	public void setDatas(DataPackage<E> datas) {
		this.datas = datas;
	}
	
	public WebUser getUser(){

		WebUser user = null;

		if (session == null || AuthTimeServiceManager.getWebUser(request) == null)
			user = getAnonymousUser();
		else
			user = AuthTimeServiceManager.getWebUser(request);

		return user;
	}
	
	
	public BaseProcess<E> getProcess() {
		return process;
	}
	
	 /**
     * Struts2序列化指定属性时，必须有该属性的getter方法
     * @return
     */
    public Map<String, Object> getDataMap() {
        return dataMap;
    }
    
    /**
     * 添加Action处理结果
     * @param isSuccess
     * 		是否成功处理
     * @param message
     * 		返回消息
     * @param data
     * 		返回数据
     */
    public Map<String, Object> addActionResult(boolean isSuccess,String message,Object data){
    	dataMap.put(ACTION_RESULT_KEY, isSuccess?ACTION_RESULT_VALUE_SUCCESS : ACTION_RESULT_VALUE_FAULT );
    	dataMap.put(ACTION_MESSAGE_KEY, message);
    	if(data != null){
    		dataMap.put(ACTION_DATA_KEY, data);
    	}
    	return dataMap;
    }
	
	private WebUser getAnonymousUser(){
		WebUser vo = new WebUser();
		vo.setId("1234-5678-90");
		vo.setName("测试用户");
		vo.setLoginno("test");
		vo.setLoginpwd("");

		return vo;
	}
}
