package com.teemlink.pm.activity.service;

import java.util.Collection;

import com.teemlink.pm.activity.dao.ActivityDAO;
import com.teemlink.pm.activity.model.Activity;
import com.teemlink.pm.base.dao.BaseDAO;
import com.teemlink.pm.base.dao.DaoManager;
import com.teemlink.pm.base.service.AbstractBaseProcessBean;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;


public class ActivityProcessBean extends AbstractBaseProcessBean<Activity>
		implements ActivityProcess {

	private static final long serialVersionUID = 3833895426776628591L;

	@Override
	public BaseDAO getDAO() throws Exception {
		return DaoManager.getActivityDAO(getConnection());
	}

	public void removeByTask(String taskId) throws Exception {
		try {
			beginTransaction();
			((ActivityDAO)getDAO()).removeByTask(taskId);
			commitTransaction();
		} catch (Exception e) {
			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
		
	}

	public Collection<Activity> doQueryActivity(ParamsTable params, WebUser user)
			throws Exception {
		return ((ActivityDAO)getDAO()).query(params, user);
	}


}
