package com.teemlink.pm.activity.controller;

import java.util.Collection;
import java.util.Map;

import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.teemlink.pm.activity.model.Activity;
import com.teemlink.pm.activity.service.ActivityProcess;
import com.teemlink.pm.activity.service.ActivityProcessBean;
import com.teemlink.pm.base.controller.BaseController;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;

@Controller(value="ActivityAction")
@RequestMapping(value="/pm/activity")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ActivityController extends BaseController<Activity> {
	
	public ActivityController() {
		super();
		content = new Activity();
		process = new ActivityProcessBean();
	}
	
	@RequestMapping(value="/query.action")
	public Map<String, Object> doQuery(){
		try {
			ParamsTable params = getParams();
			WebUser user = getUser();
			Collection<Activity> datas = ((ActivityProcess)process).doQueryActivity(params, user);
			return addActionResult(true, null, datas);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

}
