/*
Navicat MySQL Data Transfer

Source Server         : bcx
Source Server Version : 50518
Source Host           : bcxin366.mysql.rds.aliyuncs.com:3306
Source Database       : ars_test

Target Server Type    : MYSQL
Target Server Version : 50518
File Encoding         : 65001

Date: 2017-05-26 16:01:08
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for sb_business_management
-- ----------------------------
DROP TABLE IF EXISTS `sb_business_management`;
CREATE TABLE `sb_business_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `cross_city_business_county` varchar(20) DEFAULT NULL COMMENT '跨区经营县',
  `cross_city_business_city` varchar(20) DEFAULT NULL COMMENT '跨区经营市',
  `cross_city_business_province` varchar(20) DEFAULT NULL COMMENT '跨区经营市县',
  `cross_city_address` varchar(200) DEFAULT NULL COMMENT '跨区经营地址',
  `tel` varchar(50) DEFAULT NULL COMMENT '联系方式',
  `security_services_type` varchar(20) DEFAULT NULL COMMENT '保安服务类型',
  `principal` varchar(50) DEFAULT NULL COMMENT '负责人',
  `principal_phone` varchar(50) DEFAULT NULL COMMENT '负责人电话',
  `principal_id` varchar(50) DEFAULT NULL COMMENT '负责人身份证号',
  `job_name` varchar(50) DEFAULT NULL COMMENT '负责人职务',
  `filing_authority_name` varchar(50) DEFAULT NULL COMMENT '备案机关名称',
  `filing_authority_date` datetime DEFAULT NULL COMMENT '经营起始时间',
  `business_start_time` datetime DEFAULT NULL,
  `security_scope` varchar(20) DEFAULT NULL COMMENT '安保范围',
  `job_level` varchar(3) DEFAULT NULL COMMENT '职业技能等级',
  `education` varchar(3) DEFAULT NULL COMMENT '学历',
  KEY `ak_business_management_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_business_outside_management
-- ----------------------------
DROP TABLE IF EXISTS `sb_business_outside_management`;
CREATE TABLE `sb_business_outside_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `national` varchar(50) DEFAULT NULL COMMENT '涉外经营国别',
  `security_scope` varchar(20) DEFAULT NULL COMMENT '安保范围',
  `business_start_time` datetime DEFAULT NULL COMMENT '经营起始时间',
  `business_end_time` datetime DEFAULT NULL COMMENT '经营结束时间',
  `business_model` varchar(3) DEFAULT NULL COMMENT '经营模式',
  `filing_authority_name` varchar(50) DEFAULT NULL COMMENT '备案公安机关名称',
  `filing_authority_date` datetime DEFAULT NULL COMMENT '备案日期',
  `security_type` varchar(20) DEFAULT NULL COMMENT '安保类型',
  KEY `ak_business_outside_management_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_chargework
-- ----------------------------
DROP TABLE IF EXISTS `sb_chargework`;
CREATE TABLE `sb_chargework` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Confesscompanypersonid` int(11) DEFAULT NULL COMMENT '负责人ID',
  `Startdate` date DEFAULT NULL COMMENT '开始时间',
  `Enddate` date DEFAULT NULL COMMENT '结束时间',
  `Companyname` varchar(200) DEFAULT NULL COMMENT '工作单位',
  `post` varchar(50) DEFAULT NULL COMMENT '岗位',
  PRIMARY KEY (`id`),
  KEY `ak_chargework_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_confesscompany
-- ----------------------------
DROP TABLE IF EXISTS `sb_confesscompany`;
CREATE TABLE `sb_confesscompany` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Companyname` varchar(200) DEFAULT NULL COMMENT '名称',
  `Address` varchar(200) DEFAULT NULL COMMENT '公司地址',
  `Companytype` varchar(3) DEFAULT NULL,
  `Zipcode` varchar(6) DEFAULT NULL COMMENT '邮编',
  `Creditcode` varchar(50) DEFAULT NULL COMMENT '统一信用代码',
  `Personnum` int(11) DEFAULT NULL COMMENT '保安员数',
  `Legalname` varchar(20) DEFAULT NULL COMMENT '法人姓名',
  `Legalsex` varchar(3) DEFAULT NULL COMMENT '法人性别',
  `Legalnation` varchar(3) DEFAULT NULL COMMENT '法人民族',
  `Legalbirth` date DEFAULT NULL COMMENT '法人出生年月',
  `legalPolitics` varchar(3) DEFAULT NULL COMMENT '法人政治面貌',
  `legalCulture` varchar(3) DEFAULT NULL COMMENT '法人文化程度',
  `Legaltel` varchar(20) DEFAULT NULL COMMENT '法人办公电话',
  `Legalphone` varchar(20) DEFAULT NULL,
  `Legalnationality` varchar(3) DEFAULT NULL COMMENT '法人国籍',
  `Legaltype` varchar(3) DEFAULT NULL COMMENT '法人证件类型',
  `Legalcardnumber` varchar(20) DEFAULT NULL COMMENT '法人证件号码',
  `Legaladdress` varchar(200) DEFAULT NULL COMMENT '法人实际居住地址',
  `legalAbroadaddress` varchar(200) DEFAULT NULL COMMENT '法人户籍所在址/境外地址',
  `Recordaddress` varchar(200) DEFAULT NULL COMMENT '备案单位地址',
  `Recordcompanyname` varchar(200) DEFAULT NULL COMMENT '备案单位名称',
  `Recordarea` varchar(200) DEFAULT NULL COMMENT '备案单位服务区域',
  `Recordperonnum` int(11) DEFAULT NULL COMMENT '备案单位保安员数',
  `recordnoperonnum` int(11) DEFAULT NULL COMMENT '备案单位持有保安员人数',
  `Chargename` varchar(20) DEFAULT NULL COMMENT '负责人姓名',
  `Chargepost` varchar(50) DEFAULT NULL COMMENT '负责人职务',
  `Chargecardnumber` varchar(20) DEFAULT NULL COMMENT '负责人居民身份证号码',
  `Chargephone` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `Sonpersonnum` int(11) DEFAULT NULL COMMENT '子公司保安人数',
  `Sonzipcode` varchar(6) DEFAULT NULL COMMENT '子公司邮编',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(3) DEFAULT NULL COMMENT '审批状态',
  `Approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvaldate` datetime DEFAULT NULL COMMENT '审批时间',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `template_rar` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ak_confesscompany_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_confesscompanyperson
-- ----------------------------
DROP TABLE IF EXISTS `sb_confesscompanyperson`;
CREATE TABLE `sb_confesscompanyperson` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `Birth` date DEFAULT NULL COMMENT '出生年月',
  `Sex` varchar(3) DEFAULT NULL COMMENT '性别',
  `Place` varchar(3) DEFAULT NULL COMMENT '籍贯',
  `nation` varchar(3) DEFAULT NULL COMMENT '民族',
  `Education` varchar(3) DEFAULT NULL COMMENT '学历',
  `Politics` varchar(3) DEFAULT NULL COMMENT '政治面貌',
  `Culture` varchar(3) DEFAULT NULL COMMENT '文化程度',
  `cardnumber` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `Title` varchar(3) DEFAULT NULL COMMENT '技术职称或资质',
  `Post` varchar(20) DEFAULT NULL COMMENT '职务',
  `Companyname` varchar(200) DEFAULT NULL COMMENT '现工作单位',
  `confesscompanyid` int(11) DEFAULT NULL COMMENT '自招单位申请ID',
  `address` varchar(200) DEFAULT NULL COMMENT '现住地址',
  PRIMARY KEY (`id`),
  KEY `ak_confesscompanyperson_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_confessperson
-- ----------------------------
DROP TABLE IF EXISTS `sb_confessperson`;
CREATE TABLE `sb_confessperson` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Confesscompanyid` int(11) DEFAULT NULL COMMENT '自招单位申请ID',
  `Name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `Sex` varchar(3) DEFAULT NULL COMMENT '性别',
  `Age` int(11) DEFAULT NULL COMMENT '年龄',
  `Place` varchar(3) DEFAULT NULL COMMENT '籍贯',
  `address` varchar(200) DEFAULT NULL COMMENT '现住址',
  `Culture` varchar(3) DEFAULT NULL COMMENT '文化程度',
  `Politics` varchar(3) DEFAULT NULL COMMENT '政治面貌',
  `Cardnumber` varchar(20) DEFAULT NULL COMMENT '身份证号码',
  `Peronno` varchar(50) DEFAULT NULL COMMENT '保安证编号',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  PRIMARY KEY (`id`),
  KEY `ak_confessperson_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_crosscompany
-- ----------------------------
DROP TABLE IF EXISTS `sb_crosscompany`;
CREATE TABLE `sb_crosscompany` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL,
  `Companyname` varchar(200) DEFAULT NULL COMMENT '名称',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `Licencenum` varchar(50) DEFAULT NULL COMMENT '保安服务许可证号',
  `Zipcode` varchar(6) DEFAULT NULL COMMENT '邮编',
  `Creditcode` varchar(50) DEFAULT NULL COMMENT '统一社会信用号码',
  `Legalname` varchar(20) DEFAULT NULL COMMENT '法人姓名',
  `Legalsex` varchar(3) DEFAULT NULL COMMENT '法人性别',
  `Legalnation` varchar(3) DEFAULT NULL COMMENT '法人民族',
  `Legalbirth` date DEFAULT NULL COMMENT '法人出生年月',
  `legalPolitics` varchar(3) DEFAULT NULL COMMENT '法人政治面貌',
  `legalCulture` varchar(3) DEFAULT NULL COMMENT '法人文化程度',
  `Legaltel` varchar(20) DEFAULT NULL COMMENT '法人办公电话',
  `Legalphone` varchar(20) DEFAULT NULL,
  `Legalnationality` varchar(3) DEFAULT NULL COMMENT '法人国籍',
  `Legaltype` varchar(3) DEFAULT NULL COMMENT '法人证件类型',
  `Legalcardnumber` varchar(20) DEFAULT NULL COMMENT '法人证件号码',
  `Legaladdress` varchar(200) DEFAULT NULL COMMENT '法人实际居住地址',
  `legalAbroadaddress` varchar(200) DEFAULT NULL COMMENT '法人户籍所在址/境外地址',
  `Managerproject` varchar(200) DEFAULT NULL COMMENT '拟跨区域经营的',
  `Startdate` date DEFAULT NULL COMMENT '跨区域经营服务开始时间',
  `enddate` date DEFAULT NULL COMMENT '跨区域经营服务结束时间',
  `manageraddress` varchar(200) DEFAULT NULL COMMENT '拟跨区域经营地址',
  `Chargename` varchar(20) DEFAULT NULL COMMENT '负责人姓名',
  `Chargepost` varchar(50) DEFAULT NULL COMMENT '负责人职务',
  `Chargecardnumber` varchar(20) DEFAULT NULL COMMENT '负责人居民身份证号码',
  `Chargephone` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `Sonpersonnum` int(11) DEFAULT NULL COMMENT '子公司保安人数',
  `Sonzipcode` varchar(6) DEFAULT NULL COMMENT '子公司邮编',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(3) DEFAULT NULL COMMENT '审批状态',
  `Approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvaldate` datetime DEFAULT NULL COMMENT '审批时间',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `template_rar` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ak_crosscompany_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_education
-- ----------------------------
DROP TABLE IF EXISTS `sb_education`;
CREATE TABLE `sb_education` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` varchar(100) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(100) DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `school` varchar(200) DEFAULT NULL COMMENT '学校',
  `Startdate` varchar(100) DEFAULT NULL COMMENT '开始时间',
  `enddate` varchar(100) DEFAULT NULL COMMENT '结束时间',
  `Education` varchar(100) DEFAULT NULL COMMENT '学历',
  `degree` varchar(100) DEFAULT NULL COMMENT '学位',
  `Remarks` varchar(200) DEFAULT NULL COMMENT '备注',
  `personcertificateid` int(11) DEFAULT NULL COMMENT '保安证申请ID',
  PRIMARY KEY (`id`),
  KEY `ak_education_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_family
-- ----------------------------
DROP TABLE IF EXISTS `sb_family`;
CREATE TABLE `sb_family` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` varchar(100) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(100) DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `relationship` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关系',
  `Companyname` varchar(200) DEFAULT NULL COMMENT '工作单位',
  `post` varchar(50) DEFAULT NULL COMMENT '岗位',
  `personcertificateid` int(11) DEFAULT NULL COMMENT '保安员证申请ID',
  `identifType` varchar(10) DEFAULT NULL COMMENT '身份证类型',
  `identifnumber` varchar(25) DEFAULT NULL COMMENT '身份证号码',
  `phone` varchar(12) DEFAULT NULL COMMENT '联系方式',
  PRIMARY KEY (`id`),
  KEY `ak_family_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_firearms
-- ----------------------------
DROP TABLE IF EXISTS `sb_firearms`;
CREATE TABLE `sb_firearms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `update_by` varchar(50) NOT NULL,
  `userid` int(11) DEFAULT NULL,
  `firearmsnum` varchar(50) DEFAULT NULL COMMENT '枪号',
  `firearmsxh` varchar(20) DEFAULT NULL COMMENT '枪支型号',
  `firearmscompany` varchar(50) DEFAULT NULL COMMENT '枪支制作企业',
  `firearmsbuydate` datetime DEFAULT NULL COMMENT '枪支购买日期',
  `firearmsperson` varchar(50) DEFAULT NULL COMMENT '枪支专管人',
  `firearmscontext` varchar(500) DEFAULT NULL COMMENT '建立枪弹痕迹档案情况',
  `remarks` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  KEY `idx_id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=527 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_investor
-- ----------------------------
DROP TABLE IF EXISTS `sb_investor`;
CREATE TABLE `sb_investor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `investors_type` varchar(3) DEFAULT NULL COMMENT '出资人类型',
  `name` varchar(50) DEFAULT NULL COMMENT '出资人姓名',
  `id_number` varchar(18) DEFAULT NULL COMMENT '出资人身份证号',
  `nation` varchar(3) DEFAULT NULL COMMENT '民族',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `national` varchar(3) DEFAULT NULL COMMENT '国籍',
  `sex` varchar(3) DEFAULT NULL COMMENT '性别',
  `phone` varchar(50) DEFAULT NULL COMMENT '手机号',
  `nowaddress` varchar(200) DEFAULT NULL COMMENT '地址',
  `funded_number` decimal(14,2) DEFAULT NULL COMMENT '出资金额',
  `stock_proportion` decimal(2,2) DEFAULT NULL COMMENT '股份占比',
  KEY `ak_sb_investor_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_legalchange
-- ----------------------------
DROP TABLE IF EXISTS `sb_legalchange`;
CREATE TABLE `sb_legalchange` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `companyname` varchar(200) DEFAULT NULL COMMENT '单位名称',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `licencenum` varchar(50) DEFAULT NULL COMMENT '许可证',
  `legalname` varchar(50) DEFAULT NULL COMMENT '法人姓名',
  `legalsex` varchar(50) DEFAULT NULL COMMENT '法人性别',
  `officetime` datetime DEFAULT NULL COMMENT '任职时间',
  `legalcardtype` varchar(3) DEFAULT NULL COMMENT '证件类型',
  `legalcardnumber` varchar(20) DEFAULT NULL COMMENT '法人证件号码',
  `ndlegalname` varchar(50) DEFAULT NULL COMMENT '拟定法人名称',
  `ndlegalsex` varchar(3) DEFAULT NULL COMMENT '拟定法人性别',
  `ndlegalbrith` datetime DEFAULT NULL COMMENT '拟定出生年月',
  `ndlegalculture` varchar(3) DEFAULT NULL COMMENT '拟定法人文化程度',
  `ndlegalcardtype` varchar(3) DEFAULT NULL COMMENT '拟定法人证件类型',
  `ndlegalcardnum` varchar(20) DEFAULT NULL COMMENT '拟定法人证件号码',
  `ndlegalnationality` varchar(3) DEFAULT NULL COMMENT '拟定法人国籍',
  `ndlegalphone` varchar(20) DEFAULT NULL COMMENT '拟定法人手机号码',
  `ndlegaladdress` varchar(200) DEFAULT NULL COMMENT '拟定法人户籍所在 地 ',
  `ndleaglsjaddress` varchar(200) DEFAULT NULL COMMENT '拟定法人实际地址',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(3) DEFAULT NULL COMMENT '审批状态',
  `approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `approvaldate` datetime DEFAULT NULL COMMENT '审批时间',
  `template_rar` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ak_legalchange_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_legalchangeworkexperience
-- ----------------------------
DROP TABLE IF EXISTS `sb_legalchangeworkexperience`;
CREATE TABLE `sb_legalchangeworkexperience` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` varchar(255) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(30) DEFAULT NULL COMMENT '修改者',
  `companyname` varchar(200) DEFAULT NULL COMMENT '单位',
  `post` varchar(100) DEFAULT NULL,
  `startdate` datetime DEFAULT NULL COMMENT '开始时间',
  `enddate` datetime DEFAULT NULL COMMENT '结束时间',
  `remarks` varchar(255) DEFAULT NULL COMMENT '备注',
  `legalchangeid` int(11) DEFAULT NULL COMMENT '法人变更申请ID',
  PRIMARY KEY (`id`),
  KEY `ak_ legalchangeworkexperience_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_management_info
-- ----------------------------
DROP TABLE IF EXISTS `sb_management_info`;
CREATE TABLE `sb_management_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `manager_license_type` varchar(3) DEFAULT NULL COMMENT '管理人员证件类型',
  `manager_id` varchar(50) DEFAULT NULL COMMENT '管理人员证件号',
  `job_name` varchar(50) DEFAULT NULL COMMENT '职务',
  `phone` varchar(50) DEFAULT NULL COMMENT '联系方式',
  `job_level` varchar(3) DEFAULT NULL COMMENT '职业技能等级',
  `education` varchar(3) DEFAULT NULL COMMENT '学历',
  `share_ratio` decimal(2,2) DEFAULT NULL,
  KEY `ak_business_outside_management_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_personcertificate
-- ----------------------------
DROP TABLE IF EXISTS `sb_personcertificate`;
CREATE TABLE `sb_personcertificate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `Sex` varchar(20) DEFAULT NULL COMMENT '性别',
  `Brith` varchar(100) DEFAULT NULL COMMENT '出生年月',
  `Nation` varchar(50) DEFAULT NULL COMMENT '民族',
  `Politics` varchar(50) DEFAULT NULL,
  `Culture` varchar(50) DEFAULT NULL COMMENT '文化程度',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `Zipcode` varchar(50) DEFAULT NULL COMMENT '邮编',
  `Cardnumber` varchar(20) DEFAULT NULL COMMENT '身份证号码',
  `address` varchar(200) DEFAULT NULL COMMENT '户籍地址',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(50) DEFAULT NULL COMMENT '审批状态',
  `Approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvaldate` varchar(100) DEFAULT NULL COMMENT '审批时间',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `applyforstate` varchar(20) DEFAULT NULL COMMENT '申领状态',
  `beforeName` varchar(10) DEFAULT NULL COMMENT '（曾用名）',
  `guaranteecar` varchar(20) DEFAULT NULL COMMENT '保障卡',
  `familyPhone` varchar(15) DEFAULT NULL COMMENT '家庭电话',
  `militaryService` varchar(45) DEFAULT NULL COMMENT '兵役情况',
  `fingerprint` varchar(25) DEFAULT NULL COMMENT '指纹卡号',
  `religion` varchar(25) DEFAULT NULL,
  `birthPlace` varchar(50) DEFAULT NULL COMMENT '籍贯',
  `hight` varchar(10) DEFAULT NULL COMMENT '身高',
  `booldType` varchar(10) DEFAULT NULL COMMENT '血形',
  `healthStatus` varchar(25) DEFAULT NULL COMMENT '健康状况',
  `nowAddress` varchar(50) DEFAULT NULL COMMENT '现住地址',
  `baseRemack` varchar(100) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  KEY `ak_ personcertificate_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_personworkexperience
-- ----------------------------
DROP TABLE IF EXISTS `sb_personworkexperience`;
CREATE TABLE `sb_personworkexperience` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` varchar(100) DEFAULT NULL COMMENT '创建时间',
  `update_time` varchar(100) DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Companyname` varchar(200) DEFAULT NULL COMMENT '单位',
  `post` varchar(100) DEFAULT NULL,
  `startdate` varchar(100) DEFAULT NULL COMMENT 'startdate	开始时间',
  `enddate` varchar(100) DEFAULT NULL COMMENT '结束时间',
  `Remarks` varchar(200) DEFAULT NULL COMMENT '备注',
  `personcertificateid` int(11) DEFAULT NULL COMMENT '保安证申请ID',
  `workContent` varchar(200) DEFAULT NULL COMMENT '工作内容',
  `liveReason` varchar(100) DEFAULT NULL COMMENT '离职原因',
  PRIMARY KEY (`id`),
  KEY `ak_personworkexperience_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_punish
-- ----------------------------
DROP TABLE IF EXISTS `sb_punish`;
CREATE TABLE `sb_punish` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(255) DEFAULT NULL COMMENT '修改者',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `idnumber` varchar(18) DEFAULT NULL COMMENT '身份证号',
  `employeeid` varchar(50) DEFAULT NULL COMMENT '员工编号',
  `departname` varchar(50) DEFAULT NULL COMMENT '部门名称',
  `punishdate` datetime DEFAULT NULL COMMENT '处罚日期',
  `punishcontext` varchar(255) DEFAULT NULL COMMENT '处罚内容',
  `punishreason` varchar(255) DEFAULT NULL COMMENT '处罚原因',
  `punishcompany` varchar(50) DEFAULT NULL COMMENT '处罚单位',
  `remarks` varchar(100) DEFAULT NULL COMMENT '备注',
  `isbypolice` varchar(1) DEFAULT NULL COMMENT '是否由公安作出',
  KEY `ak_sb_reward_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_reward
-- ----------------------------
DROP TABLE IF EXISTS `sb_reward`;
CREATE TABLE `sb_reward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(255) DEFAULT NULL COMMENT '修改者',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `idnumber` varchar(18) DEFAULT NULL COMMENT '身份证号',
  `employeeid` varchar(50) DEFAULT NULL COMMENT '员工编号',
  `departname` varchar(50) DEFAULT NULL COMMENT '部门名称',
  `rewarddate` datetime DEFAULT NULL COMMENT '奖励日期',
  `rewardcontext` varchar(255) DEFAULT NULL COMMENT '奖励内容',
  `rewardreason` varchar(255) DEFAULT NULL COMMENT '奖励原因',
  `rewardcompany` varchar(50) DEFAULT NULL COMMENT '奖励单位',
  `remarks` varchar(100) DEFAULT NULL COMMENT '备注',
  `isbypolice` varchar(1) DEFAULT NULL COMMENT '是否公安作出',
  KEY `ak_sb_reward_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_safety
-- ----------------------------
DROP TABLE IF EXISTS `sb_safety`;
CREATE TABLE `sb_safety` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `userid` int(11) DEFAULT NULL,
  `safetynum` varchar(50) DEFAULT NULL COMMENT '设备编号',
  `safetyly` varchar(20) DEFAULT NULL COMMENT '设备来源',
  `safetyname` varchar(50) DEFAULT NULL COMMENT '设备名称',
  `safetytype` varchar(30) DEFAULT NULL COMMENT '设备类型',
  `safetypp` varchar(50) DEFAULT NULL COMMENT '设备品牌',
  `safetyxh` varchar(500) DEFAULT NULL COMMENT '设备型号',
  `safetybuydate` datetime DEFAULT NULL COMMENT '购买日期',
  `buyaccout` int(11) DEFAULT NULL COMMENT '购买金额',
  `safetyperson` varchar(50) DEFAULT NULL COMMENT '设备专管人',
  `remarks` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  KEY `idx_id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=525 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_shareholder
-- ----------------------------
DROP TABLE IF EXISTS `sb_shareholder`;
CREATE TABLE `sb_shareholder` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Sponsorlicenseid` int(11) DEFAULT NULL COMMENT '保安服务公司申请ID',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `percentage` varchar(11) DEFAULT NULL COMMENT '占股百分比',
  `investmentnum` varchar(20) DEFAULT NULL COMMENT '出资金额',
  PRIMARY KEY (`id`),
  KEY `ak_shareholder_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_sponsorlicense
-- ----------------------------
DROP TABLE IF EXISTS `sb_sponsorlicense`;
CREATE TABLE `sb_sponsorlicense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `companyname` varchar(200) DEFAULT NULL COMMENT '公司名称',
  `Tel` varchar(20) DEFAULT NULL COMMENT '电话',
  `Address` varchar(200) DEFAULT NULL COMMENT '公司地址',
  `Zipcode` varchar(6) DEFAULT NULL COMMENT '邮编',
  `management` varchar(20) DEFAULT NULL COMMENT '经营范围',
  `Enterprisetype` varchar(20) DEFAULT NULL COMMENT '企业类型',
  `Regcapital` int(11) DEFAULT NULL COMMENT '注册资本',
  `Assessmentorg` varchar(20) DEFAULT NULL COMMENT '注册资本验资或评估机构',
  `currency` int(11) DEFAULT NULL COMMENT '货币资本',
  `currencyvalue` int(11) DEFAULT NULL,
  `Representative` varchar(20) DEFAULT NULL COMMENT '拟任法定代表人',
  `phone` varchar(20) DEFAULT NULL,
  `Companymanger` int(11) DEFAULT NULL COMMENT '公司管理人员数',
  `Technologynum` int(11) DEFAULT NULL,
  `Areanum` varchar(20) DEFAULT NULL COMMENT '公司用户面积',
  `ascription` varchar(20) DEFAULT NULL COMMENT '产权归属',
  `ascriptionvehicle` int(11) DEFAULT NULL COMMENT '专属运输车辆数',
  `gunnum` int(11) DEFAULT NULL COMMENT '防暴枪支数',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(3) DEFAULT NULL,
  `Approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvaldate` date DEFAULT NULL COMMENT '审批时间',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `template_rar` varchar(500) DEFAULT NULL,
  `currencyvaluebf` varchar(10) DEFAULT NULL COMMENT '货币资本百分比',
  `currencybf` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ak_sponsorlicense_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_subsidiary
-- ----------------------------
DROP TABLE IF EXISTS `sb_subsidiary`;
CREATE TABLE `sb_subsidiary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Companyname` varchar(200) DEFAULT NULL COMMENT '公司名称',
  `Licencenum` varchar(50) DEFAULT NULL COMMENT '保安服务许可证号',
  `Address` varchar(200) DEFAULT NULL COMMENT '公司地址',
  `Creditcode` varchar(50) DEFAULT NULL COMMENT '统一信用代码',
  `Personnum` int(11) DEFAULT NULL COMMENT '保安员数',
  `Zipcode` varchar(6) DEFAULT NULL COMMENT '邮编',
  `Legalname` varchar(20) DEFAULT NULL COMMENT '法人姓名',
  `Legalsex` varchar(3) DEFAULT NULL COMMENT '法人性别',
  `Legalnation` varchar(3) DEFAULT NULL COMMENT '法人民族',
  `Legalbirth` date DEFAULT NULL COMMENT '法人出生年月',
  `legalPolitics` varchar(3) DEFAULT NULL COMMENT '法人政治面貌',
  `legalCulture` varchar(3) DEFAULT NULL COMMENT '法人文化程度',
  `Legaltel` varchar(20) DEFAULT NULL COMMENT '法人办公电话',
  `Legalphone` varchar(20) DEFAULT NULL,
  `Legalnationality` varchar(3) DEFAULT NULL COMMENT '法人国籍',
  `Legaltype` varchar(3) DEFAULT NULL COMMENT '法人证件类型',
  `Legalcardnumber` varchar(20) DEFAULT NULL COMMENT '法人证件号码',
  `Legaladdress` varchar(200) DEFAULT NULL COMMENT '法人实际居住地址',
  `legalAbroadaddress` varchar(200) DEFAULT NULL COMMENT '法人户籍所在址/境外地址',
  `Soncompanyname` varchar(200) DEFAULT NULL COMMENT '子公司名称',
  `Sonaddrss` varchar(200) DEFAULT NULL COMMENT '子公司地址',
  `Sonproject` varchar(50) DEFAULT NULL COMMENT '子公司拟开展保安服务项目',
  `Chargename` varchar(20) DEFAULT NULL COMMENT '负责人姓名',
  `Chargepost` varchar(50) DEFAULT NULL COMMENT '负责人职务',
  `Chargecardnumber` varchar(20) DEFAULT NULL COMMENT '负责人居民身份证号码',
  `Chargephone` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `Sonpersonnum` int(11) DEFAULT NULL COMMENT '子公司保安人数',
  `Sonzipcode` varchar(6) DEFAULT NULL COMMENT '子公司邮编',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(3) DEFAULT NULL COMMENT '审批状态',
  `Approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvaldate` datetime DEFAULT NULL COMMENT '审批时间',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `template_rar` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ak_subsidiary_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_subsidiary_base
-- ----------------------------
DROP TABLE IF EXISTS `sb_subsidiary_base`;
CREATE TABLE `sb_subsidiary_base` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `code` varchar(20) DEFAULT NULL COMMENT '编码',
  `company_name` varchar(50) DEFAULT NULL COMMENT '分公司名称',
  `register_address` varchar(200) DEFAULT NULL COMMENT '分公司注册地址',
  `business_place` varchar(200) DEFAULT NULL COMMENT '经营地址',
  `filing_authority_code` varchar(50) DEFAULT NULL COMMENT '备案机关编码',
  `filing_authority_name` varchar(50) DEFAULT NULL COMMENT '备案机关名称',
  `filing_authority_date` datetime DEFAULT NULL COMMENT '备案机关日期',
  `money_principal` varchar(50) DEFAULT NULL COMMENT '出资负责人',
  `money_principal_phone` varchar(50) DEFAULT NULL COMMENT '出资负责人手机',
  `money_principal_id` varchar(20) DEFAULT NULL COMMENT '出资负责人身份证号',
  KEY `ak_sb_subsidiary_base_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_subsidiary_manager
-- ----------------------------
DROP TABLE IF EXISTS `sb_subsidiary_manager`;
CREATE TABLE `sb_subsidiary_manager` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `job_name` varchar(50) DEFAULT NULL COMMENT '管理人员职务',
  `phone` varchar(50) DEFAULT NULL COMMENT '管理人员联系方式',
  `job_level` varchar(3) DEFAULT NULL COMMENT '管理人员职业技能等级',
  `job_type` varchar(3) DEFAULT NULL COMMENT '管理人员职业类型',
  `education` varchar(50) DEFAULT NULL COMMENT '管理人员学历',
  `manager_license_type` varchar(3) DEFAULT NULL COMMENT '管理人员证件类型',
  `manager_id` int(20) DEFAULT NULL COMMENT '管理人员证件号',
  KEY `ak_sb_subsidiary_manager_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sb_subsidiaryperson
-- ----------------------------
DROP TABLE IF EXISTS `sb_subsidiaryperson`;
CREATE TABLE `sb_subsidiaryperson` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `Name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `Sex` varchar(3) DEFAULT NULL COMMENT '性别',
  `Age` int(11) DEFAULT NULL COMMENT '年龄',
  `Place` varchar(3) DEFAULT NULL COMMENT '籍贯',
  `Address` varchar(200) DEFAULT NULL COMMENT '现地址',
  `Culture` varchar(3) DEFAULT NULL COMMENT '文化程度',
  `Politics` varchar(3) DEFAULT NULL COMMENT '政治面貌',
  `Cardnumber` varchar(20) DEFAULT NULL,
  `Personno` varchar(50) DEFAULT NULL COMMENT '保安员证编号',
  `Phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `subsidiaryid` int(11) DEFAULT NULL COMMENT '保安服务子公司申请ID',
  PRIMARY KEY (`id`),
  KEY `ak_subsidiaryperson_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_traincompanyapply
-- ----------------------------
DROP TABLE IF EXISTS `sb_traincompanyapply`;
CREATE TABLE `sb_traincompanyapply` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `companyname` varchar(200) DEFAULT NULL COMMENT '单位名称',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `name` varchar(100) DEFAULT NULL COMMENT '姓名',
  `post` varchar(50) DEFAULT NULL COMMENT '拟任职务',
  `sex` varchar(3) DEFAULT NULL COMMENT '性别',
  `Nation` varchar(3) DEFAULT NULL COMMENT '民族',
  `birth` date DEFAULT NULL COMMENT '出生年月',
  `politics` varchar(3) DEFAULT NULL COMMENT '政治面貌',
  `culture` varchar(3) DEFAULT NULL COMMENT '文化程度',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `place` varchar(10) DEFAULT NULL COMMENT '籍贯',
  `qualifications` varchar(20) DEFAULT NULL COMMENT '职业资质',
  `title` varchar(20) DEFAULT NULL COMMENT '技术职称',
  `userid` int(11) DEFAULT NULL COMMENT '用户ID',
  `approvalstate` varchar(3) DEFAULT NULL COMMENT '审批状态',
  `Approvalperson` varchar(20) DEFAULT NULL COMMENT '审批人',
  `approvaldate` datetime DEFAULT NULL COMMENT '审批时间',
  `approvalreason` varchar(200) DEFAULT NULL COMMENT '审批原因',
  `legalname` varchar(20) DEFAULT NULL COMMENT '法定代表人姓名',
  `creditcode` varchar(20) DEFAULT NULL COMMENT '居民身份证',
  `zipcode` varchar(10) DEFAULT NULL COMMENT '邮编',
  `organizationcode` varchar(20) DEFAULT NULL COMMENT '组织机构代码',
  `companytype` varchar(10) DEFAULT NULL COMMENT '单位性质',
  `allownumber` varchar(20) DEFAULT NULL COMMENT '保安服务许可证编号',
  `businessnumber` varchar(25) DEFAULT NULL COMMENT '营业执照编号',
  `organsallownumber` varchar(100) DEFAULT NULL COMMENT '批准机关及文号',
  `traincompanyname` varchar(200) DEFAULT NULL COMMENT '保安培训单位名称',
  `trainlegalname` varchar(20) DEFAULT NULL COMMENT '（保安培训单位）法人姓名',
  `traincreditcode` varchar(20) DEFAULT NULL COMMENT '（保安培训单位）身份证',
  `trainphone` varchar(20) DEFAULT NULL COMMENT '(保安培训单位)手机号',
  `trainaddress` varchar(200) DEFAULT NULL COMMENT '(保安培训单位)地址',
  `trainzipcode` varchar(20) DEFAULT NULL COMMENT '（保安培训单位）邮编',
  `trainsize` varchar(10) DEFAULT NULL COMMENT '保安培训单位规模',
  `traincontent` varchar(1000) DEFAULT NULL COMMENT '(保安培训单位)培训内容',
  `template_rar` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ak_traincompanyapply_key` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_vehicle
-- ----------------------------
DROP TABLE IF EXISTS `sb_vehicle`;
CREATE TABLE `sb_vehicle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) NOT NULL COMMENT '是否有效',
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  `update_by` varchar(50) NOT NULL,
  `userid` int(11) DEFAULT NULL,
  `vehiclenum` varchar(50) DEFAULT NULL COMMENT '车牌号码',
  `vehiclesource` varchar(50) DEFAULT NULL COMMENT '车辆来源',
  `vehicletype` varchar(50) DEFAULT NULL COMMENT '车辆类型',
  `vehiclebrand` varchar(50) DEFAULT NULL COMMENT '车辆品牌',
  `vehiclemodel` varchar(50) DEFAULT NULL COMMENT '车辆型号',
  `vehiclecolor` varchar(50) DEFAULT NULL COMMENT '车辆颜色',
  `fueltype` varchar(50) DEFAULT NULL COMMENT '燃料种类',
  `displacement` varchar(50) DEFAULT NULL COMMENT '发动机排量',
  `enginenum` varchar(50) DEFAULT NULL COMMENT '发动机号',
  `framenum` varchar(50) DEFAULT NULL COMMENT '车架号',
  `regdate` datetime DEFAULT NULL COMMENT '初次登记日期',
  `productiondate` datetime DEFAULT NULL COMMENT '出厂日期',
  `buydate` datetime DEFAULT NULL COMMENT '购买日期',
  `regorg` varchar(50) DEFAULT NULL COMMENT '车辆登记机关',
  `buyaccout` int(11) DEFAULT NULL,
  `chargeperson` varchar(50) DEFAULT NULL COMMENT '负责人',
  `remarks` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  KEY `idx_id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=527 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_vehicle1
-- ----------------------------
DROP TABLE IF EXISTS `sb_vehicle1`;
CREATE TABLE `sb_vehicle1` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `active` bit(1) NOT NULL COMMENT '是否可用',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT '' COMMENT '修改者',
  `vehiclenum` varchar(50) DEFAULT '' COMMENT '车牌号码',
  `vehiclesource` varchar(50) DEFAULT '' COMMENT '车辆来源',
  `vehicletype` varchar(50) DEFAULT '' COMMENT '车辆类型',
  `vehiclebrand` varchar(5) DEFAULT '' COMMENT '车辆品牌',
  `vehiclemodel` varchar(3) DEFAULT '' COMMENT '车辆型号',
  `vehiclecolor` varchar(50) DEFAULT NULL COMMENT '车辆颜色',
  `fueltype` varchar(50) DEFAULT NULL COMMENT '燃料种类',
  `displacement` varchar(50) DEFAULT NULL COMMENT '发动机排量',
  `enginenum` varchar(50) DEFAULT NULL COMMENT '发动机号',
  `framenum` varchar(50) DEFAULT NULL COMMENT '车架号',
  `regdate` datetime DEFAULT NULL COMMENT '初次登记日期',
  `regorg` varchar(50) DEFAULT NULL COMMENT '车辆登记机关',
  `productiondate` datetime DEFAULT NULL COMMENT '出厂日期',
  `buydate` datetime DEFAULT NULL COMMENT '购买日期',
  `yuyaccout` int(11) DEFAULT NULL COMMENT '购买金额',
  `chargeperson` varchar(50) DEFAULT NULL COMMENT '负责人',
  `remarks` varchar(50) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sb_workexperience
-- ----------------------------
DROP TABLE IF EXISTS `sb_workexperience`;
CREATE TABLE `sb_workexperience` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改者',
  `traincompanyapplyid` int(11) DEFAULT NULL COMMENT '培训单位审批信息ID',
  `Startdate` date DEFAULT NULL COMMENT '开始时间',
  `Enddate` date DEFAULT NULL COMMENT '结束时间',
  `companyname` varchar(200) DEFAULT NULL COMMENT '工作单位',
  `post` varchar(100) DEFAULT NULL COMMENT '岗位/职务',
  PRIMARY KEY (`id`),
  KEY `ak_workexperience_key` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
