ALTER TABLE `security_company`
ADD COLUMN `business_license_number`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '营业执照注册号' AFTER `orderNo`,
ADD COLUMN `principal`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '负责人' AFTER `business_license_number`,
ADD COLUMN `principal_phone`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '负责人电话' AFTER `principal`,
ADD COLUMN `principal_id`  varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '负责人身份证号' AFTER `principal_phone`,
ADD COLUMN `registered_money`  decimal(14,2) NULL DEFAULT NULL COMMENT '注册资金' AFTER `principal_id`,
ADD COLUMN `fixed_assets`  decimal(14,2) NULL DEFAULT NULL COMMENT '固定资产' AFTER `registered_money`,
ADD COLUMN `turnover_year`  decimal(14,2) NULL DEFAULT NULL COMMENT '年营业额' AFTER `fixed_assets`,
ADD COLUMN `annual_profits`  decimal(3,3) NULL DEFAULT NULL COMMENT '年利税' AFTER `turnover_year`,
ADD COLUMN `public_security_license_number`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '保安服务许可证号' AFTER `annual_profits`,
ADD COLUMN `national`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '国籍' AFTER `public_security_license_number`,
ADD COLUMN `economic_type`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经济类型' AFTER `national`,
ADD COLUMN `company_type`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司类型' AFTER `economic_type`,
ADD COLUMN `human_defense_level`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人力防范等级' AFTER `company_type`,
ADD COLUMN `risk_assessment_level`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '风险评估等级' AFTER `human_defense_level`,
ADD COLUMN `security_association`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属行业保安协会' AFTER `risk_assessment_level`,
ADD COLUMN `economic_type_legal_person`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '法人股东经济类型' AFTER `security_association`,
ADD COLUMN `is_subsidiary`  varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否设立子公司' AFTER `economic_type_legal_person`;

