/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.task.status;

import com.bcxin.ars.dao.sb.CrosscompanyDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CrossCompanyFilingExpiredNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(CrossCompanyFilingExpiredNotifyService.class);
    @Resource
    private JobRunLogService jobRunLogService;
    @Resource
    private SAASInterfaceUtil saasInterfaceUtil;
    @Resource
    private CrosscompanyDao crosscompanyDao;
    @Resource
    private ConfigUtils configUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!"true".equals(this.configUtils.timeFlag)) {
            return;
        }
        if ("61".equals(this.configUtils.getCurrentNative()) && !this.configUtils.isIntranet()) {
            logger.error("\u8de8\u7701\u5907\u6848\u8fc7\u671f\u63d0\u9192\u4efb\u52a1");
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setJobName(this.getClass().getName());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            log.setRunTime(new Date());
            long startTime = System.currentTimeMillis();
            try {
                List companyIds = this.crosscompanyDao.findFilingExpiredIds();
                logger.error("\u8de8\u7701\u5907\u6848\u5feb\u8fc7\u671f\u7684\u516c\u53f8:{}", (Object)companyIds);
                if (companyIds.size() > 0) {
                    StringBuilder ids = new StringBuilder();
                    companyIds.forEach(id -> {
                        if (StringUtils.isNotBlank((CharSequence)id)) {
                            ids.append((String)id).append(",");
                        }
                    });
                    ids.delete(ids.length() - 1, ids.length());
                    this.send(ids.toString(), "\u5916\u7701\u4fdd\u5b89\u8de8\u533a\u670d\u52a1\u8bbe\u7acb\u5206\u516c\u53f8\u5907\u6848\u5230\u671f\u63d0\u9192", "\u8d35\u5355\u4f4d\u6240\u7533\u8bf7\u7684\u5916\u7701\u4fdd\u5b89\u8de8\u533a\u670d\u52a1\u8bbe\u7acb\u5206\u516c\u53f8\u5907\u6848\u6709\u6548\u671f\u5373\u5c06\u5230\u671f\uff0c\u82e5\u9700\u7ee7\u7eed\u8fdb\u884c\u5916\u7701\u4fdd\u5b89\u8de8\u533a\u670d\u52a1\uff0c\u8bf7\u53ca\u65f6\u91cd\u65b0\u63d0\u4ea4\u5907\u6848\u6750\u6599\u3002\u82e5\u5df2\u91cd\u65b0\u63d0\u4ea4\uff0c\u8bf7\u5ffd\u7565\u672c\u63d0\u9192\u3002\uff08\u63d0\u4ea4\u8def\u5f84\uff1a\u3010\u4e1a\u52a1\u3011-\u3010\u8bb8\u53ef\u5907\u6848\u7533\u62a5\u3011-\u3010\u7533\u62a5\u5217\u8868\u3011-\u3010\u5916\u7701\u4fdd\u5b89\u8de8\u533a\u670d\u52a1\u8bbe\u7acb\u5206\u516c\u53f8\u5907\u6848\u3011\uff09");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                long endTime = System.currentTimeMillis();
                log.setRunTimeLength(endTime - startTime + "ms");
                log.setUpdateTime(new Date());
                this.jobRunLogService.insert(log);
            }
        }
    }

    public AjaxResult send(String companyIds, String title, String content) {
        SAASMessageDto saasMessageDto = new SAASMessageDto();
        saasMessageDto.setComIds(companyIds);
        saasMessageDto.setTitle(title);
        saasMessageDto.setContent(content);
        saasMessageDto.setPoliceRegionId(this.configUtils.getCurrentProvince());
        saasMessageDto.setMessageType("050205");
        return this.saasInterfaceUtil.sendSaasMsg(saasMessageDto);
    }
}

