/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.personcertificate;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SecurityCertificateToSaasService {
    private Logger logger = LoggerFactory.getLogger(SecurityCertificateToSaasService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCertificateService securityCertificateService;
    @Autowired
    private SecurityCertificateDao securityCertificateDao;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Value(value="${BBD_H5_URL}")
    private String bbdH5Url;
    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToSaas() {
        block15: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                long startTime;
                JobRunLog log;
                block16: {
                    if (this.configUtils.isIntranet() || !this.timeFlag.equals("true")) break block15;
                    log = new JobRunLog();
                    log.setCreateTime(new Date());
                    log.setActive(Boolean.valueOf(true));
                    log.setUpdateBy("jobSystem");
                    startTime = System.currentTimeMillis();
                    try {
                        List list = this.securityCertificateDao.findUnPushToSAAS();
                        if (list.size() <= 0) break block16;
                        final Vector saveList = new Vector();
                        final CountDownLatch workCount = ThreadUtil.newCountDownLatch((int)list.size());
                        ExecutorService threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15, (int)2000);
                        for (final SecurityCertificate securityCertificate : list) {
                            threadPoolExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        AjaxResult result;
                                        if (securityCertificate.getSnapshotId() == null) {
                                            String photo = "";
                                            photo = StringUtil.isNotEmpty((String)securityCertificate.getHeadImg()) ? securityCertificate.getHeadImg() : SecurityCertificateToSaasService.this.securityCertificateService.getPhotoUrl(securityCertificate);
                                            SecurityCertificateToSaasService.this.securityCertificateService.savePerCerSnapshot(securityCertificate, photo);
                                            securityCertificate.setUpdateTime(new Date());
                                            securityCertificate.setUpdateflag(Boolean.valueOf(true));
                                            SecurityCertificateToSaasService.this.securityCertificateDao.update(securityCertificate);
                                        }
                                        if ((result = SecurityCertificateToSaasService.this.securityCertificateService.updateSecurityPersonCertificateInfo(securityCertificate)).isSuccessful()) {
                                            saveList.add(securityCertificate);
                                        }
                                    }
                                    catch (Exception e) {
                                        SecurityCertificateToSaasService.this.logger.error(e.getMessage(), (Throwable)e);
                                        e.printStackTrace();
                                    }
                                    finally {
                                        workCount.countDown();
                                    }
                                }
                            });
                        }
                        try {
                            workCount.await();
                        }
                        catch (InterruptedException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            threadPoolExecutor.shutdown();
                        }
                        if (saveList.size() > 0) {
                            this.securityCertificateDao.batchUpdatePushState(saveList);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.error(e.getMessage(), (Throwable)e);
                        log.setExceptionMsg(e.getMessage());
                    }
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(SecurityCertificateToSaasService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.lock = false;
            }
        }
    }
}

