/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.personcertificate;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoUpdateCensorStatus {
    private Logger logger = LoggerFactory.getLogger(AutoUpdateCensorStatus.class);
    @Autowired
    private PersoncertificateService personcertificateService;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private BackgroundApprovalService backgroundApprovalService;
    private static BackGroupCensorService backGroupCensorService;
    @Autowired
    private ConfigUtils configUtils;
    private boolean lock = false;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=AutoUpdateCensorStatus.class)
    public void autoUpdateCensorStatusMethod() {
        block23: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if ("61".equals(this.configUtils.getCurrentNative())) {
                    return;
                }
                if (!this.configUtils.isIntranet() || !this.timeFlag.equals("true")) break block23;
                try {
                    this.getBackGroupCensorService();
                    List personcertificateList = this.personcertificateService.findNoCensorStatus();
                    if (personcertificateList.size() <= 0) break block23;
                    int limit = 100;
                    int count = new Double(Math.ceil((double)personcertificateList.size() * 1.0 / (double)limit)).intValue();
                    List subList = null;
                    for (int i = 0; i < count; ++i) {
                        subList = personcertificateList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)subList.size());
                        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
                        for (final Personcertificate personcertificate : subList) {
                            threadPoolExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                                        backgroundApprovalDto.setBusinessid(personcertificate.getId());
                                        backgroundApprovalDto.setBusinesstype("5");
                                        backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
                                        backgroundApprovalDto.setRealName(personcertificate.getName());
                                        PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(personcertificate.getCardnumber(), false);
                                        if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getAddress())) {
                                            personcertificate.setPopulationAddress(personBaseInfo.getAddress());
                                        }
                                        AutoUpdateCensorStatus.this.backgroundApprovalService.approval(backgroundApprovalDto);
                                        personcertificate.setCensorStatusError(Boolean.valueOf(false));
                                    }
                                    catch (Exception e) {
                                        personcertificate.setCensorStatusError(Boolean.valueOf(true));
                                        AutoUpdateCensorStatus.this.logger.error(e.getMessage(), (Throwable)e);
                                    }
                                    finally {
                                        countDownLatch.countDown();
                                    }
                                }
                            });
                        }
                        try {
                            countDownLatch.await();
                        }
                        catch (InterruptedException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            threadPoolExecutor.shutdown();
                        }
                        final CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch((int)subList.size());
                        ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor((int)15, (int)15);
                        for (final Personcertificate personcertificate : subList) {
                            threadPoolExecutor1.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (!personcertificate.getCensorStatusError().booleanValue()) {
                                            AutoUpdateCensorStatus.this.personcertificateService.updateCensorStatusForAuto(personcertificate);
                                        }
                                    }
                                    catch (Exception e) {
                                        AutoUpdateCensorStatus.this.logger.error(e.getMessage(), (Throwable)e);
                                    }
                                    finally {
                                        countDownLatch1.countDown();
                                    }
                                }
                            });
                        }
                        try {
                            countDownLatch1.await();
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        finally {
                            threadPoolExecutor1.shutdown();
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.lock = false;
            }
        }
    }
}

