/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.personGrade;

import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersonGradeDaoAop;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PersonGradeCensorStatusService {
    private static final Logger logger = LoggerFactory.getLogger(PersonGradeCensorStatusService.class);
    @Autowired
    private PersonGradeDao personGradeDao;
    @Autowired
    private PersonGradeDaoAop personGradeDaoAop;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private static BackGroupCensorService backGroupCensorService;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    public void run() {
        if (this.configUtils.isIntranet() && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                this.getBackGroupCensorService();
                List personList = this.personGradeDao.findNoCensorStatus();
                if (personList != null && personList.size() > 0) {
                    for (PersonGrade personGrade : personList) {
                        this.getCensorStatus(personGrade);
                    }
                    this.personGradeDaoAop.saveBatch(personList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(PersonGradeCensorStatusService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }

    private void getCensorStatus(PersonGrade personGrade) {
        try {
            Boolean pass = true;
            Date now = new Date();
            BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
            backgroundApprovalDto.setBusinessid(personGrade.getId());
            backgroundApprovalDto.setBusinesstype("22");
            backgroundApprovalDto.setIdNumber(personGrade.getIdNum());
            backgroundApprovalDto.setRealName(personGrade.getName());
            List list = backGroupCensorService.censor(backgroundApprovalDto);
            String approvalReason = null;
            if (list == null || list.size() == 0) {
                return;
            }
            for (BackgroundApproval backgroundApproval : list) {
                if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                approvalReason = "1".equals(backgroundApproval.getLibraryType()) ? "\u80cc\u666f\u7b5b\u67e5\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\uff1a" + backgroundApproval.getApprovalreason() : "\u80cc\u666f\u7b5b\u67e5\u4e0d\u901a\u8fc7";
                pass = false;
                break;
            }
            personGrade.setApprovalReason(approvalReason);
            if (pass.booleanValue()) {
                personGrade.setCensorStatus("1");
                personGrade.setApprovalState("0");
            } else {
                personGrade.setCensorStatus("2");
                personGrade.setApprovalState("0");
            }
            personGrade.setUpdateTime(now);
            personGrade.setUpdateflag(Boolean.valueOf(true));
            personGrade.setInTime(now);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38" + personGrade.getIdNum());
        }
    }
}

