/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.person;

import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UpdateCompanyPerNumService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCompanyPerNumService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private ComTaskPerDao comTaskPerDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Value(value="${timeFlag}")
    private String timeFlag = "";

    public void run() {
        Config config = this.configUtils.getConfigByKey("police");
        if ("0".equals(config.getValue()) && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                this.securityCompanyDao.updateNumberByTime();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(UpdateCompanyPerNumService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

