/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.person;

import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sb.ExportService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoExportPerson {
    private Logger logger = LoggerFactory.getLogger(AutoExportPerson.class);
    @Autowired
    private ExportService exportService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"45".equals(this.configUtils.getCurrentNative())) {
                    return;
                }
                if (!this.configUtils.isIntranet()) break block8;
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateBy("jobSystem");
                long startTime = System.currentTimeMillis();
                try {
                    PropertiesDTO propertiesDTO = new PropertiesDTO();
                    propertiesDTO.setTableName("v_security_person_export");
                    propertiesDTO.setExcelName("\u4fdd\u5b89\u5458\u4fe1\u606f");
                    propertiesDTO.setModelPath("com.bcxin.ars.dto.export.AutoSecurityPersonExportDto");
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    String yesterday = new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
                    HashMap<String, String> searchParams = new HashMap<String, String>();
                    searchParams.put("areaCode", "450000");
                    searchParams.put("updateTime", yesterday);
                    String jsonStr = "[{\"modekey\":\"realName\"},{\"modekey\":\"idNumber\"},{\"modekey\":\"zgcredential\"},{\"modekey\":\"companyName\"},{\"modekey\":\"orgName\"},{\"modekey\":\"districtOrgName\"},{\"modekey\":\"certificateState\"},{\"modekey\":\"identityAuthState\"},{\"modekey\":\"identityAuthTime\"},{\"modekey\":\"personType\"},{\"modekey\":\"gender\"},{\"modekey\":\"incumbencyStatus\"},{\"modekey\":\"inputDate\"},{\"modekey\":\"entrydate\"},{\"modekey\":\"leaveDate\"},{\"modekey\":\"idCardAddress\"},{\"modekey\":\"currentAddress\"},{\"modekey\":\"phone\"},{\"modekey\":\"nation\"},{\"modekey\":\"nativeName\"},{\"modekey\":\"stature\"},{\"modekey\":\"blood\"},{\"modekey\":\"age\"},{\"modekey\":\"edu\"},{\"modekey\":\"professionLevel\"},{\"modekey\":\"credential\"},{\"modekey\":\"outTimeDay\"},{\"modekey\":\"insured\"},{\"modekey\":\"comTaskFlag\"}]";
                    this.exportService.autoExportPersonInfo(propertiesDTO, jsonStr, searchParams, "\u4fdd\u5b89\u5458\u4fe1\u606f");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    log.setExceptionMsg(e.toString());
                    e.printStackTrace();
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(AutoExportPerson.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }
}

