/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.gradePerson;

import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.GradePersonService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoGradePersonCensorStatus {
    private static final Logger logger = LoggerFactory.getLogger(AutoGradePersonCensorStatus.class);
    @Autowired
    private GradePersonService gradePersonService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private BackgroundApprovalService backgroundApprovalService;
    private static BackGroupCensorService backGroupCensorService;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    public void run() {
        Config config = this.configUtils.getConfigByKey("police");
        if (config.getValue().equals("1") && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                this.getBackGroupCensorService();
                List gradePersonList = this.gradePersonService.findNoCensorStatus();
                if (gradePersonList != null && gradePersonList.size() > 0) {
                    for (GradePerson gradePerson : gradePersonList) {
                        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                        backgroundApprovalDto.setBusinessid(gradePerson.getId());
                        backgroundApprovalDto.setBusinesstype("21");
                        backgroundApprovalDto.setIdNumber(gradePerson.getIdnum());
                        backgroundApprovalDto.setRealName(gradePerson.getName());
                        List backgroundApprovals = backGroupCensorService.censor(backgroundApprovalDto);
                        gradePerson.setBackgroundApprovals(backgroundApprovals);
                    }
                    this.gradePersonService.updateCensorStatusForAuto(gradePersonList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoGradePersonCensorStatus.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

