/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncInterfaceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncToFtpService {
    private static final Logger logger = LoggerFactory.getLogger(DataSyncToFtpService.class);
    @Autowired
    private DataSyncLogDao dataSyncLogDao;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private DataSyncInterfaceUtil dataSyncInterfaceUtil;
    @Autowired
    private ConfigUtils configUtils;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"true".equals(this.configUtils.timeFlag)) break block18;
                if (!"1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                    return;
                }
                if (!"1".equals(this.configUtils.getValueByKey("DATASYNC_INTERFACE_SWITCH"))) {
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateBy("jobSystem");
                long startTime = System.currentTimeMillis();
                try {
                    List dataSyncLogList = this.dataSyncLogDao.findUnDataSyncList();
                    if (dataSyncLogList.size() > 0) {
                        Object dataSyncDto = null;
                        AjaxResult result = null;
                        ArrayList<DataSyncLog> saveList = new ArrayList<DataSyncLog>();
                        for (DataSyncLog dataSyncLog : dataSyncLogList) {
                            try {
                                result = this.dataSyncInterfaceUtil.callInterface("/ftp/file/trans", dataSyncLog);
                                if (result.isSuccessful()) {
                                    dataSyncLog.setMsgId(result.getData().toString());
                                    dataSyncLog.setDataSyncState("1");
                                    dataSyncLog.setErrorInfo("");
                                } else {
                                    dataSyncLog.setErrorInfo(result.getMsg());
                                    if (dataSyncLog.getErrorInfo().length() > 400) {
                                        dataSyncLog.setErrorInfo(dataSyncLog.getErrorInfo().substring(0, 400));
                                    }
                                }
                                dataSyncLog.setUpdateTime(new Date());
                                dataSyncLog.setUpdateflag(Boolean.valueOf(true));
                                saveList.add(dataSyncLog);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (saveList.size() > 0) {
                            this.dataSyncLogDao.saveBatch(saveList);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    log.setExceptionMsg(e.toString());
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncToFtpService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }
}

