/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncFileService {
    private static final Logger logger = LoggerFactory.getLogger(DataSyncFileService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncLogDao dataSyncLogDao;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"true".equals(this.configUtils.timeFlag)) break block18;
                if (!"1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                    return;
                }
                if (!"1".equals(this.configUtils.getValueByKey("DATASYNC_INTERFACE_SWITCH"))) {
                    return;
                }
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateBy("jobSystem");
                long startTime = System.currentTimeMillis();
                try {
                    String paths = this.configUtils.getValueByKey("DATASYNC_FILEPATHS");
                    if (StringUtil.isNotEmpty((String)paths)) {
                        Config beginDateConfig = this.configUtils.getConfigByKey("DATASYNC_BEGINDATE");
                        Date beginDate = DateUtil.getBeginDayOfYesterday();
                        if (beginDateConfig != null) {
                            beginDate = DateUtil.convertStringToDate((String)beginDateConfig.getValue());
                        }
                        List dateList = DateUtil.getBetweenDates((Date)DateUtil.getBeginDayOfYesterday(), (Date)new Date());
                        String[] pathList = paths.split("\\|\\|");
                        ArrayList<DataSyncLog> logList = new ArrayList<DataSyncLog>();
                        DataSyncLog dataSyncLog = null;
                        for (String path : pathList) {
                            for (Date date : dateList) {
                                File[] files;
                                String dirFilePath = this.configUtils.baseFolder + path.split(",")[0] + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                                File dirFile = new File(dirFilePath);
                                if (!dirFile.exists()) continue;
                                for (File file : files = dirFile.listFiles()) {
                                    dataSyncLog = this.dataSyncLogDao.findByFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                                    if (dataSyncLog != null) continue;
                                    dataSyncLog = new DataSyncLog();
                                    dataSyncLog.setActive(Boolean.valueOf(true));
                                    dataSyncLog.setBasePath(this.configUtils.baseFolder);
                                    dataSyncLog.setFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                                    dataSyncLog.setFileName(file.getName());
                                    dataSyncLog.setUrl("getResource.do?path=" + dataSyncLog.getFilePath().replace(this.configUtils.baseFolder, ""));
                                    dataSyncLog.setBusinessType(path.split(",")[1]);
                                    dataSyncLog.setDataSyncState("0");
                                    dataSyncLog.setUpdateflag(Boolean.valueOf(true));
                                    dataSyncLog.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                                    dataSyncLog.setCreateTime(new Date());
                                    dataSyncLog.setUpdateTime(new Date());
                                    dataSyncLog.setIntranet(Boolean.valueOf(this.configUtils.isIntranet()));
                                    logList.add(dataSyncLog);
                                }
                            }
                        }
                        if (logList.size() > 0) {
                            int limit = 100;
                            int count = new Double(Math.ceil((double)logList.size() * 1.0 / (double)limit)).intValue();
                            List subList = null;
                            for (int i = 0; i < count; ++i) {
                                subList = logList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                                this.dataSyncLogDao.saveBatch(subList);
                            }
                        }
                        if (beginDateConfig != null) {
                            beginDateConfig.setValue(DateUtil.getYesterday());
                            beginDateConfig.setUpdateTime(new Date());
                            this.configUtils.updateForKey(beginDateConfig);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    log.setExceptionMsg(e.toString());
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncFileService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }
}

