/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncDSOneMonthService {
    private Logger logger = LoggerFactory.getLogger(DataSyncDSOneMonthService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;
    private boolean lock = false;

    @JobLogAnnotation(getJobClazz=DataSyncDSOneMonthService.class)
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            Config config;
            Config datasynchronizationconfig;
            if ("true".equals(this.configUtils.timeFlag) && (datasynchronizationconfig = this.configUtils.getConfigByKey("datasynchronization")) != null && "1".equals(datasynchronizationconfig.getValue()) && (config = this.configUtils.getConfigByKey("police")) != null && "1".equals(config.getValue())) {
                this.policeInReadFile();
            }
        }
        finally {
            this.lock = false;
        }
    }

    private void policeInReadFile() {
        Date now = new Date();
        String lastDate = DateUtil.convertDateToString((Date)DateUtil.getBeginDayOfLastMonth(), (String)"yyyy-MM-dd");
        try {
            lastDate = DateUtil.dateAdd((int)15, (String)DateUtil.getCurrentDate(), (int)-30);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
        for (Date date : dates) {
            File dirFile;
            String dirFilePath = this.dataSyncContantsUtil.ftpFolder + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
            if ("1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                dirFilePath = this.dataSyncContantsUtil.ftpOutFolder + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
            }
            if (!(dirFile = new File(dirFilePath)).exists()) continue;
            File[] files = dirFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.getName().endsWith(".zip") || !file.getName().startsWith(this.configUtils.getDataSyncStartFileName(DataSyncAnnotation.class))) continue;
                try {
                    this.dataSyncUtil.readDSFile(DataSyncAnnotation.class, file);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

