/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.conference;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.conference.CloudConferenceDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.HuaWeiConference;
import com.bcxin.ars.dto.conference.PageConferenceInfo;
import com.bcxin.ars.model.conference.CloudConference;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.conference.CloudConferenceService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.HuaweiMeetUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UpdateConferenceStateService {
    private Logger logger = LoggerFactory.getLogger(UpdateConferenceStateService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private HuaweiMeetUtil huaweiMeetUtil;
    @Autowired
    private CloudConferenceDao cloudConferenceDao;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private CloudConferenceService cloudConferenceService;
    @Autowired
    private JobRunLogService jobRunLogService;

    public synchronized void autoUpdateConferenceState() {
        List list;
        if (!this.configUtils.isIntranet() && this.timeFlag.equals("true") && (list = this.cloudConferenceDao.findUnEnd()) != null && list.size() > 0) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                PageConferenceInfo detail;
                List huaWeiConferenceList;
                Object conferenceMap = new HashedMap();
                HashedMap paramMap = new HashedMap();
                AjaxResult result = this.huaweiMeetUtil.callInterface("GET", "/conferences", null, (Map)paramMap, true);
                if (result.isSuccessful() && (huaWeiConferenceList = (detail = (PageConferenceInfo)JSONObject.parseObject((String)JSON.toJSONString((Object)result.getData()), PageConferenceInfo.class)).getData()) != null && huaWeiConferenceList.size() > 0) {
                    huaWeiConferenceList.stream();
                    conferenceMap = huaWeiConferenceList.stream().collect(Collectors.toMap(HuaWeiConference::getConferenceID, Function.identity()));
                }
                for (CloudConference conference : list) {
                    HuaWeiConference huaWeiConference = (HuaWeiConference)conferenceMap.get(conference.getMeetId());
                    if (huaWeiConference != null) {
                        conference.setEndTime(DateUtil.utcToLocal((String)(huaWeiConference.getEndTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
                        if (StringUtil.isEmpty((String)conference.getConfUUID())) {
                            conference.setConfUUID(huaWeiConference.getConfUUID());
                        }
                        if ("Schedule".equals(huaWeiConference.getConferenceState())) {
                            conference.setState("2");
                        } else if ("Created".equals(huaWeiConference.getConferenceState())) {
                            conference.setState("1");
                        } else {
                            conference.setState("3");
                        }
                        conference.setUpdateTime(new Date());
                        this.cloudConferenceDao.updateState(conference);
                        continue;
                    }
                    this.cloudConferenceService.endConference(conference);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(UpdateConferenceStateService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

