/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.approval;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.JobRunLogService;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoApprovalProcess {
    private Logger logger = LoggerFactory.getLogger(AutoApprovalProcess.class);
    @Autowired
    private ApprovalService approvalService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private ConfigService configService;

    public void run() {
        List approvalList;
        Config config = this.configService.findByKey("police");
        if (config.getValue().equals("1") && this.timeFlag.equals("true") && (approvalList = this.approvalService.findUnStartProcess()) != null && approvalList.size() > 0) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            this.startCensorStatus(approvalList, log);
            this.startApproval(approvalList, log);
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoApprovalProcess.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCensorStatus(List<Approval> approvalList, final JobRunLog jobRunLog) {
        final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)approvalList.size());
        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
        for (final Approval approval : approvalList) {
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AutoApprovalProcess.this.approvalService.startCensorStatus(approval);
                        approval.setCensorStatusError(Boolean.valueOf(false));
                    }
                    catch (Exception e) {
                        approval.setCensorStatusError(Boolean.valueOf(true));
                        jobRunLog.setExceptionMsg(jobRunLog.getExceptionMsg() != null ? jobRunLog.getExceptionMsg() : "" + approval.getId() + "\u80cc\u666f\u7b5b\u67e5\u5931\u8d25");
                        AutoApprovalProcess.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApproval(List<Approval> approvalList, final JobRunLog jobRunLog) {
        final Long policeId = 0L;
        final String testState = "";
        final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)approvalList.size());
        ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
        for (final Approval approval : approvalList) {
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!approval.getCensorStatusError().booleanValue()) {
                            AutoApprovalProcess.this.approvalService.startApproval(approval, policeId, testState);
                        }
                    }
                    catch (Exception e) {
                        AutoApprovalProcess.this.logger.error(e.getMessage(), (Throwable)e);
                        jobRunLog.setExceptionMsg(jobRunLog.getExceptionMsg() + approval.getId() + "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25");
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
    }
}

