/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sb.BusinessService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushToAppraiseService {
    private static Logger logger = LoggerFactory.getLogger(PushToAppraiseService.class);
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private UserDao userDao;
    @Autowired
    private BusinessService businessService;
    @Autowired
    ConfigUtils configUtils;
    @Autowired
    ApprovalUtil approvalUtil;
    private boolean lock = false;

    public void reShareApprInfo() {
        String APPRAISE_SWITCH;
        if ("11".equals(this.configUtils.getCurrentNative()) && !this.configUtils.isIntranet() && this.configUtils.timeFlag.equals("true") && "1".equals(APPRAISE_SWITCH = this.configUtils.getValueByKey(Constants.APPRAISE_SWITCH))) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                List approvalList = this.approvalDAO.findUnPushToAppraise();
                for (Approval approval : approvalList) {
                    try {
                        BusinessCommon businessCommon = this.businessService.findByBusinessTypeAndId(approval.getBusinesstype(), approval.getBusinessid());
                        User user = this.userDao.findById(approval.getUserid());
                        this.approvalUtil.pushToAppraise(businessCommon, approval, user);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(PushToAppraiseService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

