/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.personcertificate;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.zw.PctinfoService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoUpdateFingerprint {
    private Logger logger = LoggerFactory.getLogger(AutoUpdateFingerprint.class);
    @Autowired
    private PctinfoService pctinfoService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigService configService;
    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;

    public void autoUpdateFingerprintMethod() {
        long startTime = System.currentTimeMillis();
        Config config = this.configService.findByKey("police");
        Config fingerConfig = this.configService.findByKey("IS_SHOW_FINGERPRINT");
        if (config.getValue().equals("1") && this.timeFlag.equals("true") && "1".equals(fingerConfig.getValue())) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            try {
                List personcertificateList = this.pctinfoService.findNofinger();
                this.autoUpdateFinger(personcertificateList);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoUpdateFingerprint.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }

    private void autoUpdateFinger(List<Personcertificate> personcertificateList) {
        if (personcertificateList != null && personcertificateList.size() > 0) {
            for (Personcertificate personcertificate : personcertificateList) {
                try {
                    this.pctinfoService.autoUpdateFingerprint(personcertificate);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

