package com.bcxin.ars.rest.thirdParty.check;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.thirdParty.PersonCheckDto;
import com.bcxin.ars.service.thirdParty.PersonCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("thirdParty/person")
public class PersonCheckController {
    /**
     * 日志
     */
    Logger logger = LoggerFactory.getLogger(PersonCheckController.class);


    @Autowired
    private PersonCheckService personCheckService;

    /***
     * 检查人员信息
     * @param dto
     * @return
     */
    @RequestMapping("check")
    @ResponseBody
    public AjaxResult check(PersonCheckDto dto){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(personCheckService.check(dto));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
