package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sb.CerLearnRecord;
import com.bcxin.ars.service.sb.CerLearnRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 资格证/等级证学习记录Controller
 * 
 * @author lin
 * @date 2020-09-08
 */
@Controller
@RequestMapping("/cerLearnRecord")
public class CerLearnRecordController {
    Logger logger = LoggerFactory.getLogger(CerLearnRecordController.class);

    @Autowired
    private CerLearnRecordService cerLearnRecordService;

    /**
     * 保存
     * @param cerLearnRecord
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(CerLearnRecord cerLearnRecord){
        AjaxResult result = new AjaxResult();
        try {
            cerLearnRecordService.save(cerLearnRecord);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}
