package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.BankAccount;
import com.bcxin.ars.service.sys.BankAccountService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;

/**
 * 银行账号信息控制器
 *
 * @author linqinglin
 * @Date 2020-05-13 14:37:13
 */
@Controller
@RequestMapping("bankAccount")
public class BankAccountController {

    Logger logger = LoggerFactory.getLogger(BankAccountController.class);

    @Autowired
    BankAccountService bankAccountService;

    @Autowired
    ArsUtil arsUtil;

    /**
     * 根据身份证查询
     * @param bankAccount
     * @return
     */
    @RequestMapping("findByIdNum")
    @ResponseBody
    public AjaxResult findByIdNum(BankAccount bankAccount){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(bankAccountService.findByIdNum(bankAccount.getIdNum()));
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 保存
     * @param bankAccount
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(@Valid BankAccount bankAccount){
        AjaxResult result = new AjaxResult();
        try {
            //1、提供信息提交接口给渤海银行对接；
            //2、接口提交参数：*姓名、*身份证号、*开户行号、*开户行名称、*卡号、*卡号状态（正常、冻结）、*激活时间（年月日时分秒）、冻结时间（年月日时分秒）、冻结原因；
            //3、接口返回参数：提交成功/提交失败。
            //4、若提交的身份证号，数据库中不存在，则新增；若存在，则以新的信息进行更新。
            //5、标*号必填，卡号状态为冻结时，冻结时间、备注必填。
            User user = arsUtil.getCurrentUser();
            bankAccount.setUpdateBy(user.getUsername());
            bankAccount.setPush(false);
            result.setSuccessful(true);
//            if(Constants.BANKACCOUNTSTATE_0.equals(bankAccount.getState())){
//                if(StringUtil.isEmpty(bankAccount.getFreezeDate())){
//                    result.setSuccessful(false);
//                    result.setMsg("freezeDate:冻结时间不能为空");
//                }else if(StringUtil.isEmpty(bankAccount.getReason())){
//                    result.setSuccessful(false);
//                    result.setMsg("reason:冻结原因不能为空");
//                }
//            }
            if(result.isSuccessful()) {
                bankAccountService.save(bankAccount);
                result.setMsg("操作成功");
            }
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("提交失败");
        }
        return result;
    }

}

