

function bootstrapTableInit(objId,url,columns){
    $("#"+objId).bootstrapTable({
        url : url,
        method : 'get',
        dataType: "json",
        pagination: true,
        queryParamsType: "limit",
        singleSelect: false,
        contentType: "application/x-www-form-urlencoded",
        pageSize: 10,
        pageNumber:1,
        search: false, //显示 搜索框
        showColumns: false, //不显示下拉框（选择显示的列）
        sidePagination: "server", //服务端请求
        queryParams: queryParams,//分页参数
        clickToSelect: true,//点击选中
        responseHandler: responseHandlerInit,
        iconSize: "outline",
        toolbar: "#tableEventsToolbar",
        columns: columns
    }).on("load-success.bs.table", function() {
        initLayerBtnClick();
    });
}

function responseHandlerInit(res) {
    if (res.total != 0) {
        return {
            "rows" : res.data,
            "total" : res.total
        }
    } else {
        return {
            "rows" : [],
            "total" : 0
        }
    }
}

function bootstrapTableDiy(objId,url,columns){
	$("#"+objId).bootstrapTable({
		url : url,
		method : 'get',
		dataType: "json",
		pagination: true,
		queryParamsType: "limit",
		singleSelect: false,
		contentType: "application/x-www-form-urlencoded",
		pageSize: 10,
		pageNumber:1,
		search: false, //显示 搜索框
		showColumns: false, //不显示下拉框（选择显示的列）
		sidePagination: "server", //服务端请求
		queryParams: queryParams,//分页参数
		clickToSelect: true,//点击选中
		responseHandler: responseHandler,
		iconSize: "outline",
		toolbar: "#tableEventsToolbar",
		columns: columns
		}).on("load-success.bs.table", function() {
			initLayerBtnClick();
		});
}

function responseHandler(res) {
	if (res.total != 0) {
		return {
			"rows" : res.rows,
			"total" : res.total
		}
	} else {
		return {
			"rows" : [],
			"total" : 0
		}
	}
}

// 设置传入参数
var isFirst = 1;

function queryParams(params) {
	// return {
	// 	numPerPage : params.limit,
	// 	pageNum : params.offset / params.limit + 1,
	// 	html : params.search,
	// 	orderDirection : params.order,
	// 	orderField : params.sort,
	// }

    var obj = g_sobj($("#searchForm").form());
    var pageNum = params.offset;
    for ( var i in obj) {
        if (obj[i] == "")
            eval("delete obj." + i);
    }
    if (isFirst == 1) {
        isFirst = 0;
        pageNum = 0;
    }

    var newParams = {
        limit : params.limit,
        pageSize : params.limit,
        pageNumber : pageNum+1,
        offset : pageNum,
		html : params.search,
        order : params.order,
        sort : params.sort,
	}
    return $.extend(obj, newParams);
};

function g_sobj(form) { /* 将form 表单元素的值序列化 */
    var obj = {};
    $.each(form.serializeArray(), function(index) {
        if (obj[this['name']]) {
            obj[this['name']] = obj[this['name']] + "," + this['value'];
        } else {
            obj[this['name']] = this['value'];
        }
    });
    return obj;
}

function initLayerBtnClick(){
	$(".ibox-content table a").click(function(event) {
		var url = $(this).attr("href");
		if ($(this).attr("target") == "dialog") {
			event.preventDefault();
			var dialogWidth = $(this).attr("width");
			var dialogHeight = $(this).attr("height");
			var title = $(this).html();
			layer.open({
				type : 2,
				title : title,
				closeBtn : 1,
				shadeClose : false,
				scrollbar : false,
				area : [ dialogWidth, dialogHeight ],
				content : url,
				skin : 'popup',
				btn : [ "确定", "取消" ],
				yes : function(indexIframe, layero) {
					// var iframeWin =
					// parent.window[layero.find('iframe')[0]['name']];
					// //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
					var body = layer.getChildFrame('body', indexIframe);
					body.find('form').submit();
				}
			});
		}else if ($(this).attr("target") == "dialogDetail") {
            event.preventDefault();
            var dialogWidth = $(this).attr("width");
            var dialogHeight = $(this).attr("height");
            var title = $(this).html();
            layer.open({
                type : 2,
                title : title,
                closeBtn : 1,
                shadeClose : false,
                scrollbar : false,
                area : [ dialogWidth, dialogHeight ],
                content : url,
                skin : 'popup'
            });
        }else if($(this).attr("target")=="ajaxTodo"){
			event.preventDefault();
			var msg = $(this).attr("title");
			var title = $(this).html();
			layer.confirm(msg, {
				title:title,
				skin : 'popup',
				btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : url,
					dataType : "json",
					//async :false,
					success : function(json) {
						layer.close(loadIndex);
						dialogAjaxDone(json);
					},error: function(xhr, ajaxOptions, thrownError){
						layer.close(loadIndex);
						ajaxError(xhr, ajaxOptions, thrownError);
					}
					});
			}, function(){
				layer.closeAll();
			});
		}
	});
}


function refresh(){
    $('#defaultTable').bootstrapTable('refresh');
}

function reSearch(){
    isFirst = 1;
    refresh();
}
